/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.kafka.mbean;

public class ObjectNameBuilder {
    private String domain;
    private String name;
    private String type;
    private String request;
    private String delayedOperation;
    private String clientId;
    private String topic;
    private String nodeId;
    private String hyfenClientId;
    private String hyfenNodeId;
    private String partition;

    private ObjectNameBuilder(String domain) {
        this.domain = domain;
    }

    static ObjectNameBuilder create(String domain) {
        return new ObjectNameBuilder(domain);
    }

    public ObjectNameBuilder type(String type) {
        this.type = type;
        return this;
    }

    public ObjectNameBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ObjectNameBuilder request(String request) {
        this.request = request;
        return this;
    }

    public ObjectNameBuilder delayedOperation(String delayedOperation) {
        this.delayedOperation = delayedOperation;
        return this;
    }

    public ObjectNameBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public ObjectNameBuilder hyfenClientId(String clientId) {
        this.hyfenClientId = clientId;
        return this;
    }

    public ObjectNameBuilder topic(String topic) {
        this.topic = topic;
        return this;
    }

    public ObjectNameBuilder nodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public ObjectNameBuilder partition(String partition) {
        this.partition = partition;
        return this;
    }

    public ObjectNameBuilder hyfenNodeId(String nodeId) {
        this.hyfenNodeId = nodeId;
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder(this.domain + ":");
        this.appendFirst(sb, "type", this.type);
        this.appendIntermediary(sb, "name", this.name);
        this.appendIntermediary(sb, "request", this.request);
        this.appendIntermediary(sb, "delayedOperation", this.delayedOperation);
        this.appendIntermediary(sb, "clientId", this.clientId);
        this.appendIntermediary(sb, "topic", this.topic);
        this.appendIntermediary(sb, "nodeId", this.nodeId);
        this.appendIntermediary(sb, "client-id", this.hyfenClientId);
        this.appendIntermediary(sb, "partition", this.partition);
        this.appendIntermediary(sb, "node-id", this.hyfenNodeId);
        return sb.toString();
    }

    private void appendFirst(StringBuilder sb, String name, String value) {
        this.append(sb, name, value, false);
    }

    private void appendIntermediary(StringBuilder sb, String name, String value) {
        this.append(sb, name, value, true);
    }

    private void append(StringBuilder sb, String name, String value, boolean intermediary) {
        if (value == null) {
            return;
        }
        if (intermediary) {
            sb.append(",");
        }
        sb.append(name);
        sb.append("=");
        sb.append(value);
    }
}

