/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.SQLFactory;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Select;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SelectStatementTest {
    @Mock
    Connection connection;
    @Mock
    DatabaseMetaData metadata;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.connection.getMetaData()).thenReturn((Object)this.metadata);
    }

    @Test
    public void testFixSQLCase() throws Exception {
        Mockito.when((Object)this.metadata.storesLowerCaseIdentifiers()).thenReturn((Object)false);
        Mockito.when((Object)this.metadata.storesUpperCaseIdentifiers()).thenReturn((Object)true);
        Select select = new Select(this.connection, JDBCUtils.H2);
        select.columns(new Column[]{SQLFactory.column((String)"id")});
        select.from(SQLFactory.table((String)"table"));
        Assert.assertEquals((Object)select.getSQL(), (Object)"SELECT ID FROM TABLE");
    }

    @Test
    public void testKeepColumnAsIs() throws Exception {
        Mockito.when((Object)this.metadata.storesLowerCaseIdentifiers()).thenReturn((Object)false);
        Mockito.when((Object)this.metadata.storesUpperCaseIdentifiers()).thenReturn((Object)true);
        Select select = new Select(this.connection, JDBCUtils.H2);
        select.columns(new Column[]{SQLFactory.column((String)"id")});
        select.from("SELECT ID as \"id\" FROM TABLE");
        Assert.assertEquals((Object)select.getSQL(), (Object)"SELECT \"id\" FROM (SELECT ID AS \"id\" FROM TABLE) \"dbSQL\"");
    }
}

