/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataprovider.sql.DatabaseTestSettings;
import org.dashbuilder.dataprovider.sql.SQLDataSetProvider;
import org.dashbuilder.dataprovider.sql.SQLFactory;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.impl.SQLDataSetDefBuilderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class SQLDataSetMetadataTest {
    @Spy
    SQLDataSetProvider dataSetProvider = SQLDataSetProvider.get();

    @Before
    public void setUp() throws Exception {
        final ArrayList<Column> dbColumns = new ArrayList<Column>();
        dbColumns.add(SQLFactory.column((String)"dbWins1", (ColumnType)ColumnType.LABEL, (int)10));
        dbColumns.add(SQLFactory.column((String)"dbWins2", (ColumnType)ColumnType.LABEL, (int)10));
        dbColumns.add(SQLFactory.column((String)"dbWins3", (ColumnType)ColumnType.LABEL, (int)10));
        this.dataSetProvider.setDataSourceLocator(new DatabaseTestSettings().getDataSourceLocator());
        ((SQLDataSetProvider)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return 0;
            }
        }).when((Object)this.dataSetProvider))._getRowCount((DataSetMetadata)Mockito.any(DataSetMetadata.class), (SQLDataSetDef)Mockito.any(SQLDataSetDef.class), (Connection)Mockito.any(Connection.class));
        ((SQLDataSetProvider)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return dbColumns;
            }
        }).when((Object)this.dataSetProvider))._getColumns((SQLDataSetDef)Mockito.any(SQLDataSetDef.class), (Connection)Mockito.any(Connection.class));
    }

    @Test
    public void testRetrieveAllColumns() throws Exception {
        DataSetMetadata metadata = this.dataSetProvider.getDataSetMetadata(((SQLDataSetDefBuilderImpl)DataSetDefFactory.newSQLDataSetDef().uuid("test")).dbTable("test", true).buildDef());
        List columnIds = metadata.getColumnIds();
        Assert.assertEquals((long)columnIds.size(), (long)3L);
        Assert.assertEquals(columnIds.get(0), (Object)"dbWins1");
        Assert.assertEquals(columnIds.get(1), (Object)"dbWins2");
        Assert.assertEquals(columnIds.get(2), (Object)"dbWins3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoColumnsDeclared() throws Exception {
        DataSetMetadata metadata = this.dataSetProvider.getDataSetMetadata(((SQLDataSetDefBuilderImpl)DataSetDefFactory.newSQLDataSetDef().uuid("test")).dbTable("test", false).buildDef());
        List columnIds = metadata.getColumnIds();
        Assert.assertEquals((long)columnIds.size(), (long)2L);
        Assert.assertEquals(columnIds.get(0), (Object)"dbWins1");
        Assert.assertEquals(columnIds.get(1), (Object)"dbWins2");
    }

    @Test
    public void testColumnsMustMatchDb() throws Exception {
        DataSetMetadata metadata = this.dataSetProvider.getDataSetMetadata(((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetDefFactory.newSQLDataSetDef().uuid("test")).label("dbwins1")).label("DBWINS2")).dbTable("test", false).buildDef());
        List columnIds = metadata.getColumnIds();
        Assert.assertEquals((long)columnIds.size(), (long)2L);
        Assert.assertEquals(columnIds.get(0), (Object)"dbWins1");
        Assert.assertEquals(columnIds.get(1), (Object)"dbWins2");
    }
}

