/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.dashbuilder.dataprovider.sql.SQLDataSetTestBase;
import org.dashbuilder.dataprovider.sql.SQLFactory;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetColumnTest;
import org.dashbuilder.dataset.DataSetFilterTest;
import org.dashbuilder.dataset.DataSetGroupTest;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetNestedGroupTest;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.junit.Assert;
import org.junit.Test;

public class SQLTableDataSetLookupTest
extends SQLDataSetTestBase {
    @Override
    public void testAll() throws Exception {
        this.testNullValues();
        this.testCurrentDate();
        this.testAvoidDuplicatedGroupColumn();
        this.testDataSetTrim();
        this.testDataSetColumns();
        this.testDataSetFilter();
        this.testDataSetGroup();
        this.testDataSetGroupByHour();
        this.testDataSetNestedGroup();
        this.testEmptyArguments();
    }

    public void insertExtraRow(String city, String dept, String employee, Date date, Double amount) throws Exception {
        SQLFactory.insert((Connection)this.conn).into(this.EXPENSES).set(this.ID, (Object)9999).set(this.CITY, (Object)city).set(this.DEPT, (Object)dept).set(this.EMPLOYEE, (Object)employee).set(this.DATE, (Object)date).set(this.AMOUNT, (Object)amount).execute();
    }

    public void deleteExtraRow() throws Exception {
        SQLFactory.delete((Connection)this.conn).from(this.EXPENSES).where(this.ID.equalsTo((Object)9999)).execute();
    }

    @Test
    public void testNullValues() throws Exception {
        try {
            this.insertExtraRow(null, null, null, null, null);
            DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.equalsTo((String)this.ID.getName(), (Comparable)Integer.valueOf(9999))})).buildLookup());
            Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
            Assertions.assertThat((Object)result.getValueAt(0, 1)).isNull();
            Assertions.assertThat((Object)result.getValueAt(0, 2)).isNull();
            Assertions.assertThat((Object)result.getValueAt(0, 3)).isNull();
            Assertions.assertThat((Object)result.getValueAt(0, 4)).isNull();
        }
        finally {
            this.deleteExtraRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCurrentDate() throws Exception {
        try {
            Date currentDate = new Date();
            this.insertExtraRow(null, null, null, currentDate, null);
            DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.equalsTo((String)this.ID.getName(), (Comparable)Integer.valueOf(9999))})).buildLookup());
            Date fromDb = (Date)result.getValueAt(0, 5);
            long seconds1 = currentDate.toInstant().getEpochSecond();
            long seconds2 = fromDb.toInstant().getEpochSecond();
            Assert.assertTrue((seconds1 == seconds2 || seconds1 == seconds2 - 1L ? 1 : 0) != 0);
        }
        finally {
            this.deleteExtraRow();
        }
    }

    @Test
    public void testAvoidDuplicatedGroupColumn() throws Exception {
        this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).group("DEPARTMENT")).column("Department")).column("AMOUNT", AggregateFunctionType.SUM)).rowNumber(3)).rowOffset(0)).buildLookup());
    }

    @Test
    public void testDataSetTrim() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).rowNumber(10)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(10);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)result.getValueAt(9, 0)).isEqualTo((Object)10.0);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).rowNumber(10)).rowOffset(40)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(10);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)41.0);
        Assertions.assertThat((Object)result.getValueAt(9, 0)).isEqualTo((Object)50.0);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).group(this.DEPT.getName())).column(this.DEPT.getName())).column(this.AMOUNT.getName(), AggregateFunctionType.SUM)).rowNumber(3)).rowOffset(0)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        Assertions.assertThat((int)result.getRowCountNonTrimmed()).isEqualTo(5);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(this.CITY.getName(), new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).rowNumber(3)).rowOffset(0)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        Assertions.assertThat((int)result.getRowCountNonTrimmed()).isEqualTo(6);
    }

    @Test
    public void testDataSetGroupByHour() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(this.ID.getName(), new ColumnFilter[]{FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.greaterOrEqualsTo((Comparable)Integer.valueOf(40)), FilterFactory.lowerOrEqualsTo((Comparable)Integer.valueOf(41))})})).group(this.DATE.getName())).dynamic(9999, DateIntervalType.HOUR, true)).column(this.DATE.getName())).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(25);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)"2012-06-12 12");
    }

    @Test
    public void testDataSetColumns() throws Exception {
        DataSetColumnTest subTest = new DataSetColumnTest();
        subTest.testDataSetLookupColumns();
        subTest.testDataSetMetadataColumns();
    }

    @Test
    public void testDataSetGroup() throws Exception {
        DataSetGroupTest subTest = new DataSetGroupTest();
        subTest.testDataSetFunctions();
        subTest.testDateMinMaxFunctions();
        subTest.testNumberMinMaxFunctions();
        subTest.testGroupByLabelDynamic();
        subTest.testGroupByExcludeLabelColumn();
        subTest.testGroupByExcludeDateColumn();
        subTest.testGroupByYearDynamic();
        subTest.testGroupByMonthDynamic();
        subTest.testGroupByMonthDynamicNonEmpty();
        subTest.testGroupByDayOfWeekDynamic();
        subTest.testGroupByFixedTrim();
        subTest.testGroupByMonthReverse();
        subTest.testGroupByMonthFixed();
        subTest.testGroupByMonthFirstMonth();
        subTest.testGroupByMonthFirstMonthReverse();
        subTest.testGroupByQuarter();
        subTest.testGroupByDateOneRow();
        subTest.testGroupByDateOneDay();
        subTest.testGroupAndCountSameColumn();
        subTest.testGroupNumberAsLabel();
    }

    @Test(expected=Exception.class)
    public void testGroupByDayOfWeekFixed() throws Exception {
        DataSetGroupTest subTest = new DataSetGroupTest();
        subTest.testGroupByDayOfWeekFixed();
    }

    @Test
    public void testDataSetNestedGroup() throws Exception {
        DataSetNestedGroupTest subTest = new DataSetNestedGroupTest();
        subTest.testGroupSelectionFilter();
        if (!this.testSettings.isMonetDB()) {
            subTest.testNestedGroupFromMultipleSelection();
        }
        subTest.testNestedGroupRequiresSelection();
        subTest.testThreeNestedLevels();
        subTest.testNoResultsSelection();
    }

    @Test
    public void testDataSetFilter() throws Exception {
        DataSetFilterTest subTest = new DataSetFilterTest();
        subTest.testColumnTypes();
        subTest.testFilterByString();
        subTest.testFilterByDate();
        subTest.testFilterByNumber();
        subTest.testFilterMultiple();
        subTest.testFilterUntilToday();
        subTest.testANDExpression();
        subTest.testNOTExpression();
        subTest.testORExpression();
        subTest.testORExpressionMultilple();
        subTest.testLogicalExprNonEmpty();
        subTest.testCombinedExpression();
        subTest.testCombinedExpression2();
        subTest.testCombinedExpression3();
        subTest.testLikeOperatorNonCaseSensitive();
        subTest.testInOperator();
        subTest.testNotInOperator();
        if (!(this.testSettings.isMySQL() || this.testSettings.isMariaDB() || this.testSettings.isSqlServer() || this.testSettings.isSybase())) {
            subTest.testLikeOperatorCaseSensitive();
        }
    }

    @Test
    public void testEmptyArguments() throws Exception {
        try {
            this.insertExtraRow(null, null, null, null, null);
            Assertions.assertThat((int)this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.equalsTo((String)this.CITY.getName(), (Comparable)null)})).buildLookup()).getRowCount()).isEqualTo(1);
            Assertions.assertThat((int)this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.equalsTo((String)this.CITY.getName(), new ArrayList())})).buildLookup()).getRowCount()).isEqualTo(51);
            Assertions.assertThat((int)this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.notEqualsTo((String)this.CITY.getName(), null)})).buildLookup()).getRowCount()).isEqualTo(50);
            Assertions.assertThat((int)this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.between((String)this.AMOUNT.getName(), null, null)})).buildLookup()).getRowCount()).isEqualTo(51);
            Assertions.assertThat((int)this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.in((String)this.CITY.getName(), null)})).buildLookup()).getRowCount()).isEqualTo(51);
            Assertions.assertThat((int)this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.in((String)this.CITY.getName(), new ArrayList())})).buildLookup()).getRowCount()).isEqualTo(51);
            Assertions.assertThat((int)this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter(new ColumnFilter[]{FilterFactory.notIn((String)this.CITY.getName(), new ArrayList())})).buildLookup()).getRowCount()).isEqualTo(51);
        }
        finally {
            this.deleteExtraRow();
        }
    }
}

