/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.ResultSetHandler;
import org.dashbuilder.dataprovider.sql.SQLDataSetProvider;
import org.dashbuilder.dataprovider.sql.SQLDataSourceLocator;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Select;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={JDBCUtils.class})
public class SQLCloseResourcesTest {
    @Mock
    Connection connection;
    @Mock
    Statement statement;
    @Mock
    ResultSet resultSet;
    @Mock
    Dialect dialect;
    @Mock
    Select select;
    @Mock
    SQLDataSourceLocator dataSourceLocator;
    @Mock
    DataSource dataSource;
    @Mock
    ResultSetMetaData metaData;
    SQLDataSetProvider sqlDataSetProvider;
    ResultSetHandler resultSetHandler;
    SQLDataSetDef dataSetDef = new SQLDataSetDef();

    @Before
    public void setUp() throws Exception {
        this.resultSetHandler = new ResultSetHandler(this.resultSet, this.statement);
        this.dataSetDef.setDataSource("test");
        this.dataSetDef.setDbSQL("test");
        this.sqlDataSetProvider = SQLDataSetProvider.get();
        this.sqlDataSetProvider.setDataSourceLocator(this.dataSourceLocator);
        Mockito.when((Object)this.dataSourceLocator.lookup((SQLDataSetDef)Matchers.any(SQLDataSetDef.class))).thenReturn((Object)this.dataSource);
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn((Object)this.connection);
        PowerMockito.mockStatic(JDBCUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)JDBCUtils.dialect((Connection)this.connection)).thenReturn((Object)this.dialect);
        Mockito.when((Object)JDBCUtils.executeQuery((Connection)((Connection)Matchers.any(Connection.class)), (String)((String)Matchers.any()))).thenReturn((Object)this.resultSetHandler);
    }

    @Test
    public void testGetColumns() throws Exception {
        this.sqlDataSetProvider._getColumns(this.dataSetDef, this.connection);
        ((Statement)Mockito.verify((Object)this.statement)).close();
        ((ResultSet)Mockito.verify((Object)this.resultSet)).close();
    }

    @Test
    public void testLookup() throws Exception {
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().column("column1")).buildLookup();
        Mockito.when((Object)JDBCUtils.getColumns((ResultSet)this.resultSet, null)).thenReturn(Arrays.asList(new Column("column1")));
        this.sqlDataSetProvider.lookupDataSet((DataSetDef)this.dataSetDef, dataSetLookup);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)3))).close();
        ((Statement)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.times((int)3))).close();
        ((Connection)Mockito.verify((Object)this.connection)).close();
    }
}

