/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.dashbuilder.dataprovider.sql.SQLDataSetTestBase;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class SQLDataSetCacheTest
extends SQLDataSetTestBase {
    @Test
    public void testDataSetNonCached() throws Exception {
        this._testDataSetCache("noncached", 100);
    }

    @Test
    public void testDataSetStaticCache() throws Exception {
        this._testDataSetCache("static", 50);
    }

    @Override
    public void testAll() throws Exception {
        this.testDataSetNonCached();
        this.testDataSetStaticCache();
    }

    protected void _testDataSetCache(String scenario, int rows) throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports_" + scenario + ".dset");
        String json = IOUtils.toString((URL)fileURL, (Charset)StandardCharsets.UTF_8);
        SQLDataSetDef def = (SQLDataSetDef)this.jsonMarshaller.fromJson(json);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports_" + scenario)).buildLookup());
        this.populateDbTable();
        Assertions.assertThat((boolean)this.sqlDataSetProvider.isDataSetOutdated((DataSetDef)def)).isEqualTo(true);
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports_" + scenario)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(rows);
    }
}

