/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import org.assertj.core.api.Assertions;
import org.dashbuilder.dataprovider.sql.DatabaseTestSettings;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.ResultSetHandler;
import org.dashbuilder.dataprovider.sql.SQLDataSetProvider;
import org.dashbuilder.dataprovider.sql.SQLFactory;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpEngine;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.impl.SQLDataSetDefBuilderImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.modules.junit4.PowerMockRunnerDelegate;

@RunWith(value=PowerMockRunner.class)
@PowerMockRunnerDelegate(value=Parameterized.class)
@PrepareForTest(value={JDBCUtils.class})
public class SQLDataSetMetadataLimitTest {
    @Mock
    Statement statement;
    @Mock
    ResultSet resultSet;
    @Mock
    DataSetOpEngine opEngine;
    @InjectMocks
    SQLDataSetProvider dataSetProvider;
    private final Dialect dialect;
    private final String limitAssertion;

    @Parameterized.Parameters(name="Dialect : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({JDBCUtils.DB2, "FETCH FIRST %d ROWS ONLY"}, {JDBCUtils.DEFAULT, "LIMIT %d"}, {JDBCUtils.H2, "LIMIT %d"}, {JDBCUtils.MYSQL, "LIMIT %d"}, {JDBCUtils.ORACLE, "FETCH FIRST %d ROWS ONLY"}, {JDBCUtils.POSTGRES, "LIMIT %d"}, {JDBCUtils.SQLSERVER, "TOP %d"}, {JDBCUtils.SYBASE_ASE, "TOP %d"});
    }

    public SQLDataSetMetadataLimitTest(Dialect dialect, String limitAssertion) {
        this.dialect = dialect;
        this.limitAssertion = limitAssertion;
    }

    @Before
    public void setUp() throws Exception {
        PowerMockito.mockStatic(JDBCUtils.class, (Class[])new Class[0]);
        ArrayList<Column> dbColumns = new ArrayList<Column>();
        dbColumns.add(SQLFactory.column((String)"dbWins1", (ColumnType)ColumnType.LABEL, (int)10));
        dbColumns.add(SQLFactory.column((String)"dbWins2", (ColumnType)ColumnType.LABEL, (int)10));
        dbColumns.add(SQLFactory.column((String)"dbWins3", (ColumnType)ColumnType.LABEL, (int)10));
        this.dataSetProvider.setDataSourceLocator(new DatabaseTestSettings().getDataSourceLocator());
        ResultSetHandler resultSetHandler = new ResultSetHandler(this.resultSet, this.statement);
        Mockito.when((Object)JDBCUtils.dialect((Connection)((Connection)ArgumentMatchers.any(Connection.class)))).thenReturn((Object)this.dialect);
        Mockito.when((Object)JDBCUtils.executeQuery((Connection)((Connection)ArgumentMatchers.any(Connection.class)), (String)((String)ArgumentMatchers.any()))).thenReturn((Object)resultSetHandler);
        Mockito.when((Object)JDBCUtils.getColumns((ResultSet)((ResultSet)ArgumentMatchers.any()), (String[])((String[])ArgumentMatchers.any()))).thenReturn(dbColumns);
        Mockito.when((Object)JDBCUtils.fixCase((Connection)((Connection)ArgumentMatchers.any(Connection.class)), (String)((String)ArgumentMatchers.eq((Object)"test")))).thenReturn((Object)"TEST");
        Mockito.when((Object)JDBCUtils.fixCase((Connection)((Connection)ArgumentMatchers.any(Connection.class)), (String)((String)ArgumentMatchers.eq((Object)"dbWins1")))).thenReturn((Object)"dbWins1");
        Mockito.when((Object)JDBCUtils.fixCase((Connection)((Connection)ArgumentMatchers.any(Connection.class)), (String)((String)ArgumentMatchers.eq((Object)"dbWins2")))).thenReturn((Object)"dbWins2");
        Mockito.when((Object)JDBCUtils.fixCase((Connection)((Connection)ArgumentMatchers.any(Connection.class)), (String)((String)ArgumentMatchers.eq((Object)"dbWins3")))).thenReturn((Object)"dbWins3");
    }

    @Test
    public void testGetColumnsWithLimitZero() throws Exception {
        DataSetMetadata metadata = this.dataSetProvider.getDataSetMetadata(((SQLDataSetDefBuilderImpl)DataSetDefFactory.newSQLDataSetDef().uuid("test")).estimateSize(false).dbTable("test", true).buildDef());
        ArgumentCaptor conn = ArgumentCaptor.forClass(Connection.class);
        ArgumentCaptor sql = ArgumentCaptor.forClass(String.class);
        PowerMockito.verifyStatic(JDBCUtils.class, (VerificationMode)Mockito.atLeastOnce());
        JDBCUtils.executeQuery((Connection)((Connection)conn.capture()), (String)((String)sql.capture()));
        MatcherAssert.assertThat((Object)((String)sql.getValue()).toUpperCase(), (Matcher)CoreMatchers.containsString((String)String.format(this.limitAssertion, 0)));
        List columnIds = metadata.getColumnIds();
        Assert.assertEquals((long)3L, (long)columnIds.size());
    }

    @Test
    public void testPostProcessingDisabledWithLimit() throws Exception {
        this.postProcessingWithLimit(false, (sql, result) -> {
            MatcherAssert.assertThat((Object)sql.toUpperCase(), (Matcher)CoreMatchers.containsString((String)String.format(this.limitAssertion, 1)));
            Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        });
    }

    @Test
    public void testPostProcessingEnabledWithLimit() throws Exception {
        Mockito.when((Object)this.opEngine.execute((DataSet)ArgumentMatchers.any(DataSet.class), (List)ArgumentMatchers.any())).then(dataSet -> dataSet.getArgument(0));
        this.postProcessingWithLimit(true, (sql, result) -> {
            MatcherAssert.assertThat((Object)sql.toUpperCase(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)String.format(this.limitAssertion, 1))));
            Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
            ((DataSetOpEngine)Mockito.verify((Object)this.opEngine)).execute((DataSet)ArgumentMatchers.any(DataSet.class), (List)ArgumentMatchers.any());
        });
    }

    private void postProcessingWithLimit(boolean postProcessing, BiConsumer<String, DataSet> assertions) throws Exception {
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().rowNumber(1)).buildLookup();
        DataSetGroup gOp = new DataSetGroup();
        ColumnGroup cg = new ColumnGroup("dbWins1", "dbWins1");
        cg.setPostEnabled(postProcessing);
        gOp.setColumnGroup(cg);
        gOp.addGroupFunction(new GroupFunction[]{new GroupFunction("dbWins2", "dbWins2", null)});
        gOp.addGroupFunction(new GroupFunction[]{new GroupFunction("dbWins3", "dbWins3", null)});
        lookup.addOperation(new DataSetOp[]{gOp});
        DataSet result = this.dataSetProvider.lookupDataSet(((SQLDataSetDefBuilderImpl)DataSetDefFactory.newSQLDataSetDef().dataSource("test").uuid("test")).estimateSize(false).dbTable("test", true).buildDef(), lookup);
        ArgumentCaptor conn = ArgumentCaptor.forClass(Connection.class);
        ArgumentCaptor sql = ArgumentCaptor.forClass(String.class);
        PowerMockito.verifyStatic(JDBCUtils.class, (VerificationMode)Mockito.atLeastOnce());
        JDBCUtils.executeQuery((Connection)((Connection)conn.capture()), (String)((String)sql.capture()));
        assertions.accept((String)sql.getValue(), result);
    }
}

