/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.ResultSetConsumer;
import org.dashbuilder.dataprovider.sql.ResultSetHandler;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Condition;
import org.dashbuilder.dataprovider.sql.model.SQLStatement;
import org.dashbuilder.dataprovider.sql.model.SortColumn;
import org.dashbuilder.dataprovider.sql.model.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Select
extends SQLStatement<Select> {
    Logger logger = LoggerFactory.getLogger(Select.class);
    protected List<Column> columns = new ArrayList<Column>();
    protected String fromSelect = null;
    protected List<Condition> wheres = new ArrayList<Condition>();
    protected List<Column> groupBys = new ArrayList<Column>();
    protected List<SortColumn> orderBys = new ArrayList<SortColumn>();
    protected int limit = -1;
    protected int offset = -1;
    protected boolean offsetPostProcessing = false;
    protected List<String> quotedFields = null;

    public Select(Connection connection, Dialect dialect) {
        super(connection, dialect);
    }

    public boolean isOffsetPostProcessing() {
        return this.offsetPostProcessing;
    }

    public void setOffsetPostProcessing(boolean offsetPostProcessing) {
        this.offsetPostProcessing = offsetPostProcessing;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public String getFromSelect() {
        return this.fromSelect;
    }

    public Table getFromTable() {
        return super.getTable();
    }

    public List<Condition> getWheres() {
        return this.wheres;
    }

    public List<Column> getGroupBys() {
        return this.groupBys;
    }

    public List<SortColumn> getOrderBys() {
        return this.orderBys;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public Select columns(Column ... cols) {
        for (Column column : cols) {
            this.columns.add(this.fix(column));
        }
        return this;
    }

    public Select columns(Collection<Column> cols) {
        for (Column column : cols) {
            this.columns.add(this.fix(column));
        }
        return this;
    }

    public Select from(String sql) {
        this.fromSelect = sql;
        return this;
    }

    public Select from(Table table) {
        return (Select)super.table(table);
    }

    public Select where(Condition condition) {
        if (condition != null) {
            this.fix(condition);
            this.wheres.add(condition);
        }
        return this;
    }

    public Select groupBy(Column column) {
        if (column != null) {
            this.groupBys.add(this.fix(column));
        }
        return this;
    }

    public Select orderBy(SortColumn ... columns) {
        for (SortColumn column : columns) {
            this.fix(column.getSource());
            this.orderBys.add(column);
        }
        return this;
    }

    public Select orderBy(List<SortColumn> columns) {
        for (SortColumn column : columns) {
            this.fix(column.getSource());
            this.orderBys.add(column);
        }
        return this;
    }

    public Select limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Select offset(int offset) {
        this.offset = offset;
        return this;
    }

    public String getSQL() {
        this.quotedFields = JDBCUtils.getWordsBetweenQuotes(this.fromSelect);
        for (Column column : this._columnsRefs) {
            String name = column.getName();
            name = this.quotedFields.contains(name) ? this.dialect.getColumnNameQuotedSQL(name) : JDBCUtils.fixCase(this.connection, name);
            column.setName(name);
        }
        this.fromSelect = this.fixCase(this.fromSelect);
        return this.dialect.getSQL(this);
    }

    public String toString() {
        return this.getSQL();
    }

    public int fetchCount() throws SQLException {
        int n;
        block8: {
            String countSql = this.dialect.getCountQuerySQL(this);
            ResultSetHandler handler = JDBCUtils.executeQuery(this.connection, countSql);
            try {
                ResultSet _rs = handler.getResultSet();
                int n2 = n = _rs.next() ? _rs.getInt(1) : 0;
                if (handler == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (handler != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.logger.debug("SQLException while fetching count with SQL command [{}]. Exception: [{}]", (Object)countSql, (Object)e);
                    throw e;
                }
            }
            handler.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R fetch(ResultSetConsumer<R> consumer) {
        try {
            String sql = this.getSQL();
            try (ResultSetHandler handler = JDBCUtils.executeQuery(this.connection, sql);){
                R r = consumer.consume(handler.getResultSet());
                return r;
            }
            catch (Exception e) {
                this.logger.debug("SQLException while fetching results with SQL command [{}]. Exception: [{}]", (Object)sql, (Object)e);
                throw e;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

