/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.metadata.backend.lucene.index.directory;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.kie.uberfire.metadata.backend.lucene.index.LuceneIndex;
import org.kie.uberfire.metadata.backend.lucene.index.directory.DeleteCommand;
import org.kie.uberfire.metadata.backend.lucene.index.directory.Directory;
import org.kie.uberfire.metadata.backend.lucene.index.directory.DirectoryFactory;
import org.kie.uberfire.metadata.backend.lucene.index.directory.DirectoryLuceneIndex;
import org.kie.uberfire.metadata.model.KCluster;

public enum DirectoryType {
    INMEMORY{

        @Override
        public LuceneIndex newIndex(KCluster cluster, IndexWriterConfig config) {
            Directory directory = new Directory((org.apache.lucene.store.Directory)new RAMDirectory(), new DeleteCommand(){

                @Override
                public void execute(org.apache.lucene.store.Directory directory) {
                }
            }, true);
            return new DirectoryLuceneIndex(cluster, directory, config);
        }
    }
    ,
    NIO{

        @Override
        public LuceneIndex newIndex(KCluster cluster, IndexWriterConfig config) {
            NIOFSDirectory luceneDir;
            final File clusterDir = DirectoryType.clusterDir(cluster.getClusterId());
            try {
                luceneDir = new NIOFSDirectory(clusterDir);
            }
            catch (IOException e) {
                throw new org.uberfire.java.nio.IOException((Exception)e);
            }
            Directory directory = new Directory((org.apache.lucene.store.Directory)luceneDir, new DeleteCommand(){

                @Override
                public void execute(org.apache.lucene.store.Directory directory) {
                    ((NIOFSDirectory)directory).close();
                    FileDeleteStrategy.FORCE.deleteQuietly(clusterDir);
                }
            }, DirectoryType.freshIndex(clusterDir));
            return new DirectoryLuceneIndex(cluster, directory, config);
        }
    }
    ,
    MMAP{

        @Override
        public LuceneIndex newIndex(KCluster cluster, IndexWriterConfig config) {
            MMapDirectory luceneDir;
            final File clusterDir = DirectoryType.clusterDir(cluster.getClusterId());
            try {
                luceneDir = new MMapDirectory(clusterDir);
            }
            catch (IOException e) {
                throw new org.uberfire.java.nio.IOException((Exception)e);
            }
            Directory directory = new Directory((org.apache.lucene.store.Directory)luceneDir, new DeleteCommand(){

                @Override
                public void execute(org.apache.lucene.store.Directory directory) {
                    ((MMapDirectory)directory).close();
                    FileDeleteStrategy.FORCE.deleteQuietly(clusterDir);
                }
            }, DirectoryType.freshIndex(clusterDir));
            return new DirectoryLuceneIndex(cluster, directory, config);
        }
    };


    public abstract LuceneIndex newIndex(KCluster var1, IndexWriterConfig var2);

    private static File clusterDir(String clusterId) {
        return new File(DirectoryFactory.defaultHostingDir(), clusterId);
    }

    private static boolean freshIndex(File clusterDir) {
        return !clusterDir.exists();
    }
}

