/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.metadata.io;

import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.uberfire.metadata.engine.Indexer;
import org.kie.uberfire.metadata.engine.MetaIndexEngine;
import org.kie.uberfire.metadata.io.IndexersFactory;
import org.kie.uberfire.metadata.io.KObjectUtil;
import org.kie.uberfire.metadata.model.KCluster;
import org.kie.uberfire.metadata.model.KObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public final class BatchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(BatchIndex.class);
    private final MetaIndexEngine indexEngine;
    private final IOService ioService;
    private final Class<? extends FileAttributeView>[] views;
    private final AtomicBoolean indexDisposed = new AtomicBoolean(false);

    public BatchIndex(MetaIndexEngine indexEngine, IOService ioService, Class<? extends FileAttributeView> ... views) {
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
        this.views = views;
    }

    public void runAsync(final FileSystem fs) {
        if (fs != null && fs.getRootDirectories().iterator().hasNext()) {
            SimpleAsyncExecutorService.getDefaultInstance().execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return "FS BatchIndex [" + ((FileSystemId)fs).id() + "]";
                }

                public void run() {
                    block3: {
                        final AtomicBoolean indexFinished = new AtomicBoolean(false);
                        BatchIndex.this.indexEngine.beforeDispose(new Runnable(){

                            @Override
                            public void run() {
                                BatchIndex.this.indexDisposed.set(true);
                                if (!indexFinished.get()) {
                                    BatchIndex.this.indexEngine.delete(KObjectUtil.toKCluster(fs));
                                }
                            }
                        });
                        try {
                            for (Path root : fs.getRootDirectories()) {
                                BatchIndex.this.run(root);
                            }
                            indexFinished.set(true);
                        }
                        catch (Exception ex) {
                            if (BatchIndex.this.indexDisposed.get()) break block3;
                            LOG.error("FileSystem Index fails. [@" + fs.toString() + "]", (Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    public void runAsync(final Path root) {
        SimpleAsyncExecutorService.getDefaultInstance().execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "Path BatchIndex [" + root.toString() + "]";
            }

            public void run() {
                BatchIndex.this.run(root);
            }
        });
    }

    public void run(Path root) {
        this.run(root, null);
    }

    public void run(final Path root, Runnable callback) {
        try {
            if (root == null) {
                return;
            }
            KCluster cluster = KObjectUtil.toKCluster(root.getFileSystem());
            this.indexEngine.startBatch(cluster);
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)root)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (BatchIndex.this.indexDisposed.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (!file.getFileName().toString().startsWith(".")) {
                            for (Class view : BatchIndex.this.views) {
                                BatchIndex.this.ioService.getFileAttributeView(file, view);
                            }
                            FileAttribute[] allAttrs = BatchIndex.this.ioService.convert(BatchIndex.this.ioService.readAttributes(file));
                            if (BatchIndex.this.indexDisposed.get()) {
                                return FileVisitResult.TERMINATE;
                            }
                            BatchIndex.this.indexEngine.index(KObjectUtil.toKObject(file, allAttrs));
                            for (Indexer indexer : IndexersFactory.getIndexers()) {
                                KObject kObject;
                                if (!indexer.supportsPath(file) || (kObject = indexer.toKObject(file)) == null) continue;
                                if (!BatchIndex.this.indexDisposed.get()) {
                                    BatchIndex.this.indexEngine.index(kObject);
                                    continue;
                                }
                                return FileVisitResult.TERMINATE;
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (BatchIndex.this.indexDisposed.get()) {
                            LOG.warn("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
                            return FileVisitResult.TERMINATE;
                        }
                        LOG.error("Index fails. [@" + file.toString() + "]", (Throwable)ex);
                    }
                    if (BatchIndex.this.indexDisposed.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (!this.indexDisposed.get()) {
                this.indexEngine.commit(cluster);
                if (callback != null) {
                    callback.run();
                }
            } else {
                LOG.warn("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
            }
        }
        catch (IllegalStateException ex) {
            if (this.indexDisposed.get()) {
                LOG.warn("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
            } else {
                LOG.error("Index fails - Index has an invalid state. [@" + root.toUri().toString() + "]", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            if (this.indexDisposed.get()) {
                LOG.warn("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
            }
            LOG.error("Index fails. [@" + root.toUri().toString() + "]", (Throwable)ex);
        }
    }

    public void dispose() {
        this.indexEngine.dispose();
    }
}

