/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.perspective.editor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.uberfire.perspective.editor.model.NewPerspectiveEditorEvent;
import org.kie.uberfire.perspective.editor.model.PerspectiveEditor;
import org.kie.uberfire.perspective.editor.model.PerspectiveEditorPersistenceAPI;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;

@Service
@ApplicationScoped
public class PerspectiveEditorPersistence
implements PerspectiveEditorPersistenceAPI {
    public static final String PERSPECTIVE_EDITOR = "perspective-editor";
    private Gson gson;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    private Event<NewPerspectiveEditorEvent> newPerspectiveEventEvent;

    @PostConstruct
    public void setup() {
        this.gsonFactory();
    }

    public List<PerspectiveEditor> loadAll() {
        ArrayList<PerspectiveEditor> list = new ArrayList<PerspectiveEditor>();
        Collection<String> perspectives = this.listPerspectives();
        for (String perspective : perspectives) {
            list.add(this.load(perspective));
        }
        return list;
    }

    public Collection<String> listPerspectives() {
        final ArrayList<String> result = new ArrayList<String>();
        Path perspectivesDir = this.fileSystem.getPath(PERSPECTIVE_EDITOR, new String[0]);
        if (this.ioService.exists(perspectivesDir)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)perspectivesDir)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (attrs.isRegularFile()) {
                            org.uberfire.backend.vfs.Path path = Paths.convert((Path)file);
                            result.add(file.getFileName().toString());
                        }
                    }
                    catch (Exception ex) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result;
    }

    public PerspectiveEditor load(String perspectiveName) {
        Path perspectiveFile = this.resolvePerspectivePath(perspectiveName);
        String fileContent = this.ioService.readAllString(perspectiveFile);
        PerspectiveEditor perspectiveEditorJSON = (PerspectiveEditor)this.gson.fromJson(fileContent, PerspectiveEditor.class);
        return perspectiveEditorJSON;
    }

    public void save(PerspectiveEditor perspectiveContent) {
        Path perspectiveFile = this.resolvePerspectivePath(perspectiveContent.getName());
        String json = this.gson.toJson((Object)perspectiveContent);
        this.ioService.write(perspectiveFile, json, new OpenOption[0]);
        this.newPerspectiveEventEvent.fire((Object)new NewPerspectiveEditorEvent(perspectiveContent));
    }

    private Path resolvePerspectivePath(String perspectiveFile) {
        Path perspectivePath = this.fileSystem.getPath(PERSPECTIVE_EDITOR, new String[0]);
        return perspectivePath.resolve(perspectiveFile);
    }

    void gsonFactory() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        this.gson = gsonBuilder.create();
    }
}

