/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.plugin.backend;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.uberfire.plugin.backend.MediaServletURI;
import org.kie.uberfire.plugin.event.MediaDeleted;
import org.kie.uberfire.plugin.event.PluginAdded;
import org.kie.uberfire.plugin.event.PluginDeleted;
import org.kie.uberfire.plugin.event.PluginSaved;
import org.kie.uberfire.plugin.exception.PluginAlreadyExists;
import org.kie.uberfire.plugin.model.CodeType;
import org.kie.uberfire.plugin.model.DynamicMenu;
import org.kie.uberfire.plugin.model.DynamicMenuItem;
import org.kie.uberfire.plugin.model.Framework;
import org.kie.uberfire.plugin.model.Language;
import org.kie.uberfire.plugin.model.Media;
import org.kie.uberfire.plugin.model.Plugin;
import org.kie.uberfire.plugin.model.PluginContent;
import org.kie.uberfire.plugin.model.PluginSimpleContent;
import org.kie.uberfire.plugin.model.PluginType;
import org.kie.uberfire.plugin.model.RuntimePlugin;
import org.kie.uberfire.plugin.service.PluginServices;
import org.kie.uberfire.plugin.type.TypeConverterUtil;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.rpc.SessionInfo;

@Service
@ApplicationScoped
public class PluginServicesImpl
implements PluginServices {
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    @Named(value="MediaServletURI")
    private MediaServletURI mediaServletURI;
    @Inject
    private transient SessionInfo sessionInfo;
    @Inject
    private Event<PluginAdded> pluginAddedEvent;
    @Inject
    private Event<PluginDeleted> pluginDeletedEvent;
    @Inject
    private Event<PluginSaved> pluginSavedEvent;
    @Inject
    private Event<MediaDeleted> mediaDeletedEvent;
    private Gson gson;

    @PostConstruct
    public void init() {
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public String getMediaServletURI() {
        return this.mediaServletURI.getURI();
    }

    public Collection<RuntimePlugin> listRuntimePlugins() {
        final ArrayList runtimePlugins = new ArrayList();
        Path plugins = this.fileSystem.getPath("plugins", new String[]{"/"});
        final HashSet frameworks = new HashSet();
        if (this.ioService.exists(plugins)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)plugins)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (file.getFileName().toString().endsWith(".registry.js") && attrs.isRegularFile()) {
                            String pluginName = file.getParent().getFileName().toString();
                            frameworks.addAll(PluginServicesImpl.this.loadFramework(pluginName));
                            runtimePlugins.add(new RuntimePlugin(PluginServicesImpl.this.loadCss(pluginName), PluginServicesImpl.this.ioService.readAllString(file)));
                        }
                    }
                    catch (Exception ex) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        ArrayList<RuntimePlugin> result = new ArrayList<RuntimePlugin>(frameworks.size() + runtimePlugins.size());
        for (Framework framework : frameworks) {
            try {
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)this.getClass().getClassLoader().getResourceAsStream("/frameworks/" + framework.toString().toLowerCase() + ".dependency"), (Writer)writer);
                result.add(new RuntimePlugin("", writer.toString()));
            }
            catch (Exception ignored) {}
        }
        result.addAll(runtimePlugins);
        return result;
    }

    public Collection<Plugin> listPlugins() {
        final ArrayList<Plugin> result = new ArrayList<Plugin>();
        Path plugins = this.fileSystem.getPath("plugins", new String[]{"/"});
        if (this.ioService.exists(plugins)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)plugins)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (file.getFileName().toString().endsWith(".plugin") && attrs.isRegularFile()) {
                            org.uberfire.backend.vfs.Path path = Paths.convert((Path)file);
                            result.add(new Plugin(file.getParent().getFileName().toString(), TypeConverterUtil.fromPath((org.uberfire.backend.vfs.Path)path), path));
                        }
                    }
                    catch (Exception ex) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result;
    }

    public Plugin createNewPlugin(String pluginName, PluginType type) {
        PortablePreconditions.checkNotEmpty((String)"pluginName", (String)pluginName);
        Path pluginRoot = this.getPluginPath(pluginName);
        if (this.ioService.exists(pluginRoot)) {
            throw new PluginAlreadyExists();
        }
        Path pluginPath = this.ioService.createFile(pluginRoot.resolve(type.toString().toLowerCase() + ".plugin"), new FileAttribute[0]);
        this.updatePlugin(pluginPath, pluginName, type, true);
        return new Plugin(pluginName, type, Paths.convert((Path)pluginPath));
    }

    private void updatePlugin(Path pluginPath, String pluginName, PluginType type, boolean isNewPlugIn) {
        this.ioService.write(pluginPath, new Date().toString(), new OpenOption[0]);
        if (isNewPlugIn) {
            this.pluginAddedEvent.fire((Object)new PluginAdded(new Plugin(pluginName, type, Paths.convert((Path)pluginPath)), this.sessionInfo));
        } else {
            this.pluginSavedEvent.fire((Object)new PluginSaved(pluginName, type, this.sessionInfo));
        }
    }

    public PluginContent getPluginContent(org.uberfire.backend.vfs.Path path) {
        String pluginName = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().getFileName().toString();
        return new PluginContent(pluginName, TypeConverterUtil.fromPath((org.uberfire.backend.vfs.Path)path), path, this.loadTemplate(pluginName), this.loadCss(pluginName), this.loadCodeMap(pluginName), this.loadFramework(pluginName), Language.JAVASCRIPT, this.loadMediaLibrary(pluginName));
    }

    public void save(PluginSimpleContent plugin) {
        boolean isNewPlugin;
        Path pluginPath = Paths.convert((org.uberfire.backend.vfs.Path)plugin.getPath());
        boolean bl = isNewPlugin = !this.ioService.exists(pluginPath);
        if (isNewPlugin) {
            this.ioService.createFile(this.getPluginPath(plugin.getName()).resolve(plugin.getType().toString().toLowerCase() + ".plugin"), new FileAttribute[0]);
        }
        this.saveCodeMap(plugin.getName(), plugin.getCodeMap());
        if (plugin.getTemplate() != null) {
            this.ioService.write(this.getTemplatePath(this.getPluginPath(plugin.getName())), plugin.getTemplate(), new OpenOption[0]);
        }
        if (plugin.getCss() != null) {
            this.ioService.write(this.getCssPath(this.getPluginPath(plugin.getName())), plugin.getCss(), new OpenOption[0]);
        }
        try {
            if (plugin.getFrameworks() != null && !plugin.getFrameworks().isEmpty()) {
                Framework fm = (Framework)plugin.getFrameworks().iterator().next();
                this.ioService.createFile(this.getDependencyPath(this.getPluginPath(plugin.getName()), fm), new FileAttribute[0]);
            }
        }
        catch (FileAlreadyExistsException ex) {
            // empty catch block
        }
        this.createRegistry(plugin);
        this.updatePlugin(pluginPath, plugin.getName(), plugin.getType(), isNewPlugin);
    }

    private Path getDependencyPath(Path pluginPath, Framework framework) {
        return pluginPath.resolve("dependencies").resolve(framework.toString() + ".dependency");
    }

    private void createRegistry(PluginSimpleContent plugin) {
        Path path = this.getPluginPath(plugin.getName());
        StringBuilder sb = new StringBuilder();
        if (plugin.getCodeMap().containsKey(CodeType.MAIN)) {
            sb.append((String)plugin.getCodeMap().get(CodeType.MAIN));
        }
        if (plugin.getType().equals((Object)PluginType.SCREEN)) {
            sb.append("$registerPlugin({");
        } else if (plugin.getType().equals((Object)PluginType.SPLASH)) {
            sb.append("$registerSplashScreen({");
        } else if (plugin.getType().equals((Object)PluginType.EDITOR)) {
            sb.append("$registerEditor({");
        }
        if (plugin.getType().equals((Object)PluginType.PERSPECTIVE)) {
            sb.append("$registerPerspective({");
        }
        sb.append("id:").append('\"').append(plugin.getName()).append('\"').append(",");
        if (plugin.getCodeMap().size() > 1) {
            for (Map.Entry entry : plugin.getCodeMap().entrySet()) {
                if (((CodeType)entry.getKey()).equals((Object)CodeType.MAIN)) continue;
                sb.append(((CodeType)entry.getKey()).toString().toLowerCase()).append(": ");
                sb.append((String)entry.getValue()).append(",");
            }
        } else {
            sb.append(",");
        }
        if (plugin.getFrameworks() != null && !plugin.getFrameworks().isEmpty()) {
            Framework fm = (Framework)plugin.getFrameworks().iterator().next();
            sb.append("type: ").append('\"').append(fm.getType()).append('\"').append(',');
        }
        if (!plugin.getType().equals((Object)PluginType.PERSPECTIVE)) {
            sb.append("template: ");
            this.gson.toJson((Object)plugin.getTemplate(), (Appendable)sb);
        } else {
            sb.append("view: {").append(plugin.getTemplate()).append("}");
        }
        sb.append("});");
        this.ioService.write(path.resolve(plugin.getName() + ".registry.js"), sb.toString(), new OpenOption[0]);
    }

    private void saveCodeMap(String pluginName, Map<CodeType, String> codeMap) {
        Path rootPlugin = this.getPluginPath(pluginName);
        for (Map.Entry<CodeType, String> entry : codeMap.entrySet()) {
            Path codePath = this.getCodePath(rootPlugin, entry.getKey());
            this.ioService.write(codePath, entry.getValue(), new OpenOption[0]);
        }
    }

    private Map<CodeType, String> loadCodeMap(String pluginName) {
        try {
            Path rootPlugin = this.getPluginPath(pluginName);
            DirectoryStream stream = this.ioService.newDirectoryStream(this.getCodeRoot(rootPlugin), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

                public boolean accept(Path entry) throws IOException {
                    return entry.getFileName().toString().endsWith(".code");
                }
            });
            HashMap<CodeType, String> result = new HashMap<CodeType, String>();
            for (Path path : stream) {
                CodeType type = this.getCodeType(path);
                if (type == null) continue;
                result.put(type, this.ioService.readAllString(path));
            }
            return result;
        }
        catch (NotDirectoryException exception) {
            return Collections.emptyMap();
        }
    }

    private Set<Media> loadMediaLibrary(String pluginName) {
        try {
            Path rootPlugin = this.getPluginPath(pluginName);
            DirectoryStream stream = this.ioService.newDirectoryStream(this.getMediaRoot(rootPlugin));
            HashSet<Media> result = new HashSet<Media>();
            for (Path path : stream) {
                result.add(new Media("/" + this.getMediaServletURI() + pluginName + "/media/" + path.getFileName(), Paths.convert((Path)path)));
            }
            return result;
        }
        catch (NotDirectoryException exception) {
            return Collections.emptySet();
        }
    }

    private String loadTemplate(String pluginName) {
        Path template = this.getTemplatePath(this.getPluginPath(pluginName));
        if (this.ioService.exists(template)) {
            return this.ioService.readAllString(template);
        }
        return "";
    }

    private String loadCss(String pluginName) {
        Path css = this.getCssPath(this.getPluginPath(pluginName));
        if (this.ioService.exists(css)) {
            return this.ioService.readAllString(css);
        }
        return "";
    }

    private Set<Framework> loadFramework(String pluginName) {
        try {
            HashSet<Framework> result = new HashSet<Framework>();
            DirectoryStream stream = this.ioService.newDirectoryStream(this.getPluginPath(pluginName).resolve("dependencies"));
            for (Path path : stream) {
                try {
                    result.add(Framework.valueOf((String)path.getFileName().toString().replace(".dependency", "").toUpperCase()));
                }
                catch (Exception ignored) {}
            }
            return result;
        }
        catch (NotDirectoryException exception) {
            return Collections.emptySet();
        }
    }

    private Path getTemplatePath(Path rootPlugin) {
        return rootPlugin.resolve("template.html");
    }

    private Path getCssPath(Path rootPlugin) {
        return rootPlugin.resolve("css").resolve("style.css");
    }

    private Path getCodePath(Path rootPlugin, CodeType codeType) {
        return this.getCodeRoot(rootPlugin).resolve(codeType.toString().toLowerCase() + ".code");
    }

    private CodeType getCodeType(Path path) {
        try {
            return CodeType.valueOf((String)path.getFileName().toString().replace(".code", "").toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Path getCodeRoot(Path rootPlugin) {
        return rootPlugin.resolve("code");
    }

    private Path getMediaRoot(Path rootPlugin) {
        return rootPlugin.resolve("media");
    }

    private Path getPluginPath(String name) {
        return this.fileSystem.getPath("plugins", new String[]{"/" + name});
    }

    public void delete(Plugin plugin) {
        Path pluginPath = Paths.convert((org.uberfire.backend.vfs.Path)plugin.getPath());
        if (this.ioService.exists(pluginPath)) {
            this.ioService.delete(pluginPath.getParent(), new DeleteOption[]{StandardDeleteOption.NON_EMPTY_DIRECTORIES});
            this.pluginDeletedEvent.fire((Object)new PluginDeleted(plugin.getName(), plugin.getType(), this.sessionInfo));
        }
    }

    public void deleteMedia(Media media) {
        Path mediaPath = Paths.convert((org.uberfire.backend.vfs.Path)media.getPath());
        this.ioService.delete(mediaPath, new DeleteOption[0]);
        this.mediaDeletedEvent.fire((Object)new MediaDeleted(mediaPath.getParent().getParent().getFileName().toString(), media));
    }

    public DynamicMenu getDynamicMenuContent(org.uberfire.backend.vfs.Path path) {
        String pluginName = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().getFileName().toString();
        return new DynamicMenu(pluginName, TypeConverterUtil.fromPath((org.uberfire.backend.vfs.Path)path), path, this.loadMenuItems(pluginName));
    }

    public void save(DynamicMenu plugin) {
        boolean isNewPlugin;
        Path pluginPath = Paths.convert((org.uberfire.backend.vfs.Path)plugin.getPath());
        boolean bl = isNewPlugin = !this.ioService.exists(pluginPath);
        if (isNewPlugin) {
            this.ioService.createFile(this.getPluginPath(plugin.getName()).resolve(plugin.getType().toString().toLowerCase() + ".plugin"), new FileAttribute[0]);
        }
        Path menuItemsPath = this.getMenuItemsPath(this.getPluginPath(plugin.getName()));
        StringBuilder sb = new StringBuilder();
        for (DynamicMenuItem item : plugin.getMenuItems()) {
            sb.append(item.getActivityId()).append(" / ").append(item.getMenuLabel()).append("\n");
        }
        this.ioService.write(menuItemsPath, sb.toString(), new OpenOption[0]);
        this.updatePlugin(pluginPath, plugin.getName(), plugin.getType(), isNewPlugin);
    }

    public Collection<DynamicMenu> listDynamicMenus() {
        final ArrayList<DynamicMenu> result = new ArrayList<DynamicMenu>();
        Path plugins = this.fileSystem.getPath("plugins", new String[]{"/"});
        if (this.ioService.exists(plugins)) {
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)plugins)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (file.getFileName().toString().equalsIgnoreCase("info.dynamic") && attrs.isRegularFile()) {
                            String pluginName = file.getParent().getFileName().toString();
                            result.add(new DynamicMenu(pluginName, PluginType.DYNAMIC_MENU, Paths.convert((Path)file.getParent()), PluginServicesImpl.this.loadMenuItems(pluginName)));
                        }
                    }
                    catch (Exception ex) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return result;
    }

    private Collection<DynamicMenuItem> loadMenuItems(String pluginName) {
        ArrayList<DynamicMenuItem> result = new ArrayList<DynamicMenuItem>();
        Path menuItemsPath = this.getMenuItemsPath(this.getPluginPath(pluginName));
        if (this.ioService.exists(menuItemsPath)) {
            List value = this.ioService.readAllLines(menuItemsPath);
            for (String s : value) {
                String[] items = s.split("/");
                if (items.length != 2) continue;
                result.add(new DynamicMenuItem(items[0].trim(), items[1].trim()));
            }
        }
        return result;
    }

    private Path getMenuItemsPath(Path rootPlugin) {
        return rootPlugin.resolve("info.dynamic");
    }
}

