/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.plugin.backend;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FilenameUtils;
import org.kie.uberfire.plugin.backend.MediaServletURI;
import org.kie.uberfire.plugin.event.MediaAdded;
import org.kie.uberfire.plugin.model.Media;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.server.BaseUploadServlet;
import org.uberfire.server.MimeType;

public class PluginMediaServlet
extends BaseUploadServlet {
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem fileSystem;
    @Inject
    private Event<MediaAdded> newMediaEvent;
    private final int PLACEHOLDER_SIZE;
    private final int NOTFOUND_SIZE = (int)new File(((Object)((Object)this)).getClass().getResource("/nofound.png").getFile()).length();
    private String pattern = "/plugins/";
    private static MediaServletURI mediaServletURI = new MediaServletURI("plugins/");

    public PluginMediaServlet() {
        this.PLACEHOLDER_SIZE = (int)new File(((Object)((Object)this)).getClass().getResource("/placeholder.png").getFile()).length();
    }

    public void init(ServletConfig config) throws ServletException {
        String pattern = config.getInitParameter("url-pattern");
        if (pattern != null && !pattern.trim().isEmpty()) {
            this.pattern = pattern.endsWith("/") ? pattern : pattern + "/";
            if (this.pattern.startsWith("/")) {
                mediaServletURI.setURI(this.pattern.substring(1));
            } else {
                mediaServletURI.setURI(this.pattern);
            }
        }
    }

    @Produces
    @Named(value="MediaServletURI")
    public MediaServletURI produceMediaServletURI() {
        return mediaServletURI;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        InputStream in;
        String mime = null;
        String filename = URIUtil.decode((String)req.getRequestURI().substring(req.getContextPath().length()));
        Path mediaPath = this.fileSystem.getPath("plugins", new String[]{filename.replace(this.pattern, "/")});
        if (!this.ioService.exists(mediaPath)) {
            mime = "image/png";
            resp.setContentLength(this.NOTFOUND_SIZE);
            in = ((Object)((Object)this)).getClass().getResourceAsStream("/nofound.png");
        } else {
            mime = MimeType.fromExtension((String)("." + FilenameUtils.getExtension((String)mediaPath.getFileName().toString()))).getType();
            if (mime != null && !mime.startsWith("image/")) {
                mime = "image/png";
                resp.setContentLength(this.PLACEHOLDER_SIZE);
                in = ((Object)((Object)this)).getClass().getResourceAsStream("/placeholder.png");
            } else {
                resp.setContentLength((int)this.ioService.size(mediaPath));
                in = this.ioService.newInputStream(mediaPath, new OpenOption[0]);
            }
        }
        if (mime == null) {
            resp.setStatus(500);
            return;
        }
        resp.setContentType(mime);
        ServletOutputStream out = resp.getOutputStream();
        byte[] buf = new byte[1024];
        int count = 0;
        while ((count = in.read(buf)) >= 0) {
            out.write(buf, 0, count);
        }
        out.close();
        in.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        try {
            String filename = req.getRequestURI().substring(req.getContextPath().length());
            String pluginName = filename.replace(this.pattern, "/");
            if (pluginName != null) {
                FileItem fileItem = this.getFileItem(req);
                Path path = this.fileSystem.getPath("plugins", new String[]{pluginName, "media", fileItem.getName()});
                if (this.ioService.exists(path)) {
                    this.writeResponse(response, "FAIL - ALREADY EXISTS");
                    return;
                }
                this.writeFile(this.ioService, path, fileItem);
                this.newMediaEvent.fire((Object)new MediaAdded(pluginName.substring(1), new Media(this.pattern + pluginName.substring(1) + "/media/" + path.getFileName(), Paths.convert((Path)path))));
                this.writeResponse(response, "OK");
            }
        }
        catch (Exception e) {
            this.logError(e);
            this.writeResponse(response, "FAIL");
        }
    }
}

