/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.client.widgets.item.bundle;

import org.junit.Assert;
import org.junit.Test;
import org.kie.uberfire.social.activities.client.widgets.item.bundle.DuplicatedTranslationException;
import org.kie.uberfire.social.activities.client.widgets.item.bundle.SocialBundleHelper;
import org.kie.uberfire.social.activities.client.widgets.item.bundle.SocialBundleService;

public class SocialBundleHelperTest {
    @Test
    public void getTranslationFromServiceWithNoPreviouslyFoundTranslationTest() throws DuplicatedTranslationException {
        String value = SocialBundleHelper.getTranslationFromService((String)"key", null, (SocialBundleService)this.getService());
        Assert.assertEquals((Object)"value", (Object)value);
    }

    @Test
    public void getTranslationFromServiceWithoutValueWithNoPreviouslyFoundTranslationTest() throws DuplicatedTranslationException {
        String value = SocialBundleHelper.getTranslationFromService((String)"key", null, (SocialBundleService)this.getServiceWithoutValue());
        Assert.assertNull((Object)value);
    }

    @Test(expected=DuplicatedTranslationException.class)
    public void getTranslationFromServiceWithPreviouslyFoundTranslationTest() throws DuplicatedTranslationException {
        SocialBundleHelper.getTranslationFromService((String)"key", (String)"previously-found-value", (SocialBundleService)this.getService());
    }

    @Test
    public void getTranslationFromServiceWithoutValueWithPreviouslyFoundTranslationTest() throws DuplicatedTranslationException {
        String value = SocialBundleHelper.getTranslationFromService((String)"key", (String)"previously-found-value", (SocialBundleService)this.getServiceWithoutValue());
        Assert.assertEquals((Object)"previously-found-value", (Object)value);
    }

    private SocialBundleService getService() {
        return new SocialBundleService(){

            public String getTranslation(String key) {
                return "value";
            }
        };
    }

    private SocialBundleService getServiceWithoutValue() {
        return new SocialBundleService(){

            public String getTranslation(String key) {
                return null;
            }
        };
    }
}

