/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.client.user;

import com.google.gwt.user.client.ui.Image;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.uberfire.social.activities.client.gravatar.GravatarBuilder;
import org.kie.uberfire.social.activities.client.user.SocialUserImageProvider;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.service.SocialUserImageRepositoryAPI;

@ApplicationScoped
public class SocialUserImageProviderImpl
implements SocialUserImageProvider {
    @Inject
    Instance<SocialUserImageRepositoryAPI> imageRepository;

    @Override
    public Image getImageForSocialUser(SocialUser socialUser, SocialUserImageRepositoryAPI.ImageSize imageSize) {
        if (this.imageRepository.isUnsatisfied()) {
            return this.createDefaultImage(socialUser, imageSize);
        }
        String url = ((SocialUserImageRepositoryAPI)this.imageRepository.get()).imageUrlForSocialUser(socialUser, imageSize);
        if (url == null) {
            return this.createDefaultImage(socialUser, imageSize);
        }
        return new Image(url);
    }

    private Image createDefaultImage(SocialUser socialUser, SocialUserImageRepositoryAPI.ImageSize imageSize) {
        return GravatarBuilder.generate(socialUser, imageSize);
    }
}

