/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.client.widgets.userbox;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.Caption;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.ThumbnailPanel;
import org.gwtbootstrap3.client.ui.constants.ImageType;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.jboss.errai.ioc.client.container.IOC;
import org.kie.uberfire.social.activities.client.resources.i18n.Constants;
import org.kie.uberfire.social.activities.client.user.SocialUserImageProvider;
import org.kie.uberfire.social.activities.client.widgets.utils.FollowButton;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.service.SocialUserImageRepositoryAPI;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class UserBoxView
extends Composite {
    private static HeaderViewBinder uiBinder = (HeaderViewBinder)GWT.create(HeaderViewBinder.class);
    private static final Constants constants = Constants.INSTANCE;
    @UiField
    Caption caption;
    @UiField
    ThumbnailPanel panel;
    @UiField
    Heading username;
    @UiField
    Paragraph desc;
    private SocialUserImageProvider userImageProvider = (SocialUserImageProvider)IOC.getBeanManager().lookupBean(SocialUserImageProvider.class, new Annotation[0]).getInstance();

    public void init(SocialUser socialUser, RelationType type, ParameterizedCommand<String> onClick, ParameterizedCommand<String> followUnfollowCommand) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setupUserBox(socialUser, this.userImageProvider.getImageForSocialUser(socialUser, SocialUserImageRepositoryAPI.ImageSize.BIG), onClick);
        this.setupFollowUnfollow(socialUser, type, followUnfollowCommand);
    }

    private void setupFollowUnfollow(final SocialUser socialUser, RelationType type, final ParameterizedCommand<String> followUnfollowCommand) {
        if (type != RelationType.ME && followUnfollowCommand != null) {
            FollowButton.FollowType followType = type == RelationType.UNFOLLOW ? FollowButton.FollowType.UNFOLLOW : FollowButton.FollowType.FOLLOW;
            Command wrapper = new Command(){

                public void execute() {
                    followUnfollowCommand.execute((Object)socialUser.getUserName());
                }
            };
            FollowButton button = new FollowButton(followType, wrapper);
            button.addStyleName("center-block");
            this.caption.add((Widget)button);
        }
    }

    private void setupUserBox(final SocialUser socialUser, com.google.gwt.user.client.ui.Image userImage, final ParameterizedCommand<String> onClick) {
        Image image = new Image(userImage.getUrl());
        image.setType(ImageType.CIRCLE);
        image.setPixelSize(140, 140);
        if (onClick != null) {
            image.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    onClick.execute((Object)socialUser.getUserName());
                }
            });
        }
        this.panel.insert((Widget)image, 0);
        this.createLink(socialUser, onClick);
        if (socialUser.getEmail().isEmpty()) {
            this.desc.getElement().getStyle().setVisibility(Style.Visibility.HIDDEN);
            this.desc.setText(".");
        } else {
            this.desc.setText(socialUser.getEmail());
        }
    }

    private void createLink(final SocialUser follower, final ParameterizedCommand<String> command) {
        this.username.setText(follower.getName());
        if (command != null) {
            this.username.addDomHandler((EventHandler)new ClickHandler(){

                public void onClick(ClickEvent event) {
                    command.execute((Object)follower.getUserName());
                }
            }, ClickEvent.getType());
            this.username.addDomHandler((EventHandler)new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    UserBoxView.this.username.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                }
            }, MouseOverEvent.getType());
        }
    }

    public String getUserName() {
        return this.username.getText();
    }

    static /* synthetic */ Constants access$000() {
        return constants;
    }

    public static enum RelationType {
        CAN_FOLLOW(UserBoxView.access$000().Follow()),
        UNFOLLOW(UserBoxView.access$000().Unfollow()),
        ME;

        private String label;

        private RelationType() {
        }

        public String label() {
            return this.label;
        }

        private RelationType(String label) {
            this.label = label;
        }
    }

    static interface HeaderViewBinder
    extends UiBinder<Widget, UserBoxView> {
    }
}

