/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.client.widgets.utils;

import java.util.Date;
import org.kie.uberfire.social.activities.client.resources.i18n.Constants;

public class SocialDateFormatter {
    private static final Constants constants = Constants.INSTANCE;

    public static String format(Date date) {
        int diffInDays = SocialDateFormatter.diffInDaysFromNow(date);
        if (diffInDays < 7) {
            return SocialDateFormatter.formatInDays(diffInDays);
        }
        return SocialDateFormatter.formatInWeeks(diffInDays);
    }

    private static int diffInDaysFromNow(Date date) {
        int diffInDays = (int)((new Date().getTime() - date.getTime()) / 86400000L);
        return Math.abs(diffInDays);
    }

    private static String formatInWeeks(int diffInDays) {
        int numberOfWeeks = diffInDays / 7;
        if (numberOfWeeks == 1 || numberOfWeeks == 0) {
            return constants.OneWeekAgo();
        }
        return numberOfWeeks + " " + constants.WeeksAgo();
    }

    private static String formatInDays(int diffInDays) {
        if (diffInDays == 0) {
            return constants.Today();
        }
        if (diffInDays == 1) {
            return diffInDays + " " + constants.DayAgo();
        }
        return diffInDays + " " + constants.DaysAgo();
    }
}

