/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.guvnor.ala.build.Project;
import org.guvnor.ala.build.maven.executor.MavenTestUtils;
import org.guvnor.ala.build.maven.model.impl.MavenProjectImpl;
import org.guvnor.ala.build.maven.util.MavenBuildExecutor;
import org.guvnor.ala.build.maven.util.RepositoryVisitor;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.registry.inmemory.InMemorySourceRegistry;
import org.guvnor.ala.source.Source;
import org.guvnor.ala.source.git.config.GitConfig;
import org.guvnor.ala.source.git.config.impl.GitConfigImpl;
import org.guvnor.ala.source.git.executor.GitConfigExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class MavenCliOutputTest {
    private File tempPath;
    private String gitUrl;

    @Before
    public void setUp() throws Exception {
        this.tempPath = Files.createTempDirectory("zzz", new FileAttribute[0]).toFile();
        this.gitUrl = MavenTestUtils.createGitRepoWithPom(this.tempPath, new File[0]);
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Test
    public void buildAppAndWaitForMavenOutputTest() throws IOException {
        Optional _source = new GitConfigExecutor((SourceRegistry)new InMemorySourceRegistry()).apply((GitConfig)new GitConfigImpl(this.tempPath.getAbsolutePath(), "master", this.gitUrl, "drools-workshop", "true"));
        Assert.assertTrue((boolean)_source.isPresent());
        Source source = (Source)_source.get();
        boolean buildProcessReady = false;
        Object error = null;
        PipedOutputStream baosOut = new PipedOutputStream();
        PipedOutputStream baosErr = new PipedOutputStream();
        PrintStream out = new PrintStream(baosOut, true);
        PrintStream err = new PrintStream(baosErr, true);
        new Thread(() -> this.buildMavenProject(source, out, err)).start();
        StringBuilder sb = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new PipedInputStream(baosOut)));
        while (!buildProcessReady && error == null) {
            String line = bufferedReader.readLine();
            if (line == null) continue;
            sb.append(line).append("\n");
            if (!line.contains("Building war:")) continue;
            buildProcessReady = true;
            out.close();
            err.close();
            baosOut.close();
            baosErr.close();
        }
        Assert.assertTrue((boolean)sb.toString().contains("Building war:"));
        Assert.assertTrue((boolean)buildProcessReady);
        Assert.assertTrue((error == null ? 1 : 0) != 0);
    }

    private void buildMavenProject(Source source, PrintStream out, PrintStream err) throws org.uberfire.java.nio.IOException, SecurityException, UnsupportedOperationException, IllegalArgumentException {
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("package");
        Properties p = new Properties();
        p.setProperty("failIfNoTests", "false");
        InputStream pomStream = org.uberfire.java.nio.file.Files.newInputStream((Path)source.getPath().resolve("pom.xml"), (OpenOption[])new OpenOption[0]);
        MavenProject project = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
        String expectedBinary = project.getArtifact().getArtifactId() + "-" + project.getArtifact().getVersion() + "." + project.getArtifact().getType();
        MavenProjectImpl mavenProject = new MavenProjectImpl(project.getId(), project.getArtifact().getType(), project.getName(), expectedBinary, source.getPath(), source.getPath(), source.getPath().resolve("target").resolve(expectedBinary).toAbsolutePath(), null, null);
        File pom = new File(this.getRepositoryVisitor((Project)mavenProject).getRoot(), "pom.xml");
        MavenBuildExecutor.executeMaven((File)pom, (PrintStream)out, (PrintStream)err, (Properties)p, (String[])goals.toArray(new String[0]));
    }

    private RepositoryVisitor getRepositoryVisitor(Project project) {
        return new RepositoryVisitor(project.getPath(), project.getName());
    }
}

