/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TempFileManager {
    public static final String TMPDIR_PROPERTY = "swarm.io.tmpdir";
    public static final String WFSWARM_TMP_PREFIX = "wfswarm";
    public static final TempFileManager INSTANCE = new TempFileManager();
    private Set<File> registered = Collections.newSetFromMap(new ConcurrentHashMap());
    private File tmpDir;

    private TempFileManager() {
        String tmpDir = System.getProperty(TMPDIR_PROPERTY);
        if (tmpDir != null) {
            this.tmpDir = new File(tmpDir);
            if (!Files.exists(this.tmpDir.toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectories(this.tmpDir.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public File newTempDirectory(String base, String ext) throws IOException {
        File tmp = File.createTempFile(WFSWARM_TMP_PREFIX + base, ext, this.tmpDir);
        tmp.delete();
        tmp.mkdirs();
        this.register(tmp);
        return tmp;
    }

    public File newTempFile(String base, String ext) throws IOException {
        File tmp = File.createTempFile(WFSWARM_TMP_PREFIX + base, ext, this.tmpDir);
        tmp.delete();
        this.register(tmp);
        return tmp;
    }

    private void register(File file) {
        this.registered.add(file);
    }

    public void close() {
        for (File file : this.registered) {
            TempFileManager.deleteRecursively(file);
        }
    }

    public static boolean deleteRecursively(File f) {
        if (!f.exists()) {
            return false;
        }
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (TempFileManager.deleteRecursively(children[i])) continue;
                return false;
            }
        }
        return f.delete();
    }
}

