/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.tests;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.io.FileUtils;
import org.guvnor.ala.build.maven.config.impl.MavenBuildConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenBuildExecConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenProjectConfigImpl;
import org.guvnor.ala.build.maven.executor.MavenTestUtils;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.docker.config.impl.ContextAwareDockerProvisioningConfig;
import org.guvnor.ala.docker.config.impl.ContextAwareDockerRuntimeExecConfig;
import org.guvnor.ala.docker.config.impl.DockerBuildConfigImpl;
import org.guvnor.ala.docker.config.impl.DockerProviderConfigImpl;
import org.guvnor.ala.docker.model.DockerProvider;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.pipeline.PipelineConfigStage;
import org.guvnor.ala.pipeline.impl.PipelineConfigImpl;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.services.api.PipelineService;
import org.guvnor.ala.services.api.RuntimeProvisioningService;
import org.guvnor.ala.services.api.itemlist.PipelineConfigsList;
import org.guvnor.ala.services.api.itemlist.ProviderList;
import org.guvnor.ala.services.api.itemlist.ProviderTypeList;
import org.guvnor.ala.services.api.itemlist.RuntimeList;
import org.guvnor.ala.source.git.config.impl.GitConfigImpl;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;

public class PipelineEndpointsTestIT {
    private final String APP_URL = "http://localhost:8080/api/";
    private File tempPath;
    private String gitUrl;

    @Before
    public void setUp() throws Exception {
        this.tempPath = Files.createTempDirectory("xxx", new FileAttribute[0]).toFile();
        this.gitUrl = MavenTestUtils.createGitRepoWithPom((File)this.tempPath, (File[])new File[0]);
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Ignore
    public void checkService() {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://localhost:8080/api/");
        ResteasyWebTarget restEasyTarget = (ResteasyWebTarget)target;
        PipelineService proxyPipeline = (PipelineService)restEasyTarget.proxy(PipelineService.class);
        RuntimeProvisioningService proxyRuntime = (RuntimeProvisioningService)restEasyTarget.proxy(RuntimeProvisioningService.class);
        ProviderTypeList allProviderTypes = proxyRuntime.getProviderTypes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertNotNull((Object)allProviderTypes);
        Assert.assertEquals((long)3L, (long)allProviderTypes.getItems().size());
        DockerProviderConfigImpl dockerProviderConfig = new DockerProviderConfigImpl();
        proxyRuntime.registerProvider((ProviderConfig)dockerProviderConfig);
        ProviderList allProviders = proxyRuntime.getProviders(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allProviders.getItems().size());
        Assert.assertTrue((boolean)(allProviders.getItems().get(0) instanceof DockerProvider));
        PipelineConfigsList allPipelines = proxyPipeline.getPipelineConfigs(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertNotNull((Object)allPipelines);
        Assert.assertEquals((long)0L, (long)allPipelines.getItems().size());
        ArrayList<PipelineConfigStage> configs = new ArrayList<PipelineConfigStage>();
        configs.add(new PipelineConfigStage("GitConfig", (Config)new GitConfigImpl()));
        configs.add(new PipelineConfigStage("MavenProjectConfig", (Config)new MavenProjectConfigImpl()));
        configs.add(new PipelineConfigStage("MavenBuildConfig", (Config)new MavenBuildConfigImpl()));
        configs.add(new PipelineConfigStage("DockerBuildConfig", (Config)new DockerBuildConfigImpl()));
        configs.add(new PipelineConfigStage("MavenBuildExecConfig", (Config)new MavenBuildExecConfigImpl()));
        configs.add(new PipelineConfigStage("DockerProviderConfig", (Config)new DockerProviderConfigImpl()));
        configs.add(new PipelineConfigStage("ContextAwareDockerProvisioning", (Config)new ContextAwareDockerProvisioningConfig()));
        configs.add(new PipelineConfigStage("ContextAwareDockerRuntimeExec", (Config)new ContextAwareDockerRuntimeExecConfig()));
        String newPipeline = proxyPipeline.newPipeline((PipelineConfig)new PipelineConfigImpl("mypipe", configs));
        Input input = new Input();
        input.put((Object)"repo-name", (Object)"drools-workshop");
        input.put((Object)"create-repo", (Object)"true");
        input.put((Object)"branch", (Object)"master");
        input.put((Object)"out-dir", (Object)this.tempPath.getAbsolutePath());
        input.put((Object)"origin", (Object)this.gitUrl);
        proxyPipeline.runPipeline("mypipe", input, false);
        RuntimeList allRuntimes = proxyRuntime.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.getItems().size());
        proxyRuntime.destroyRuntime(((Runtime)allRuntimes.getItems().get(0)).getId(), true);
        allRuntimes = proxyRuntime.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)0L, (long)allRuntimes.getItems().size());
    }
}

