/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.tests;

import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.docker.config.impl.DockerProviderConfigImpl;
import org.guvnor.ala.docker.config.impl.DockerRuntimeConfigImpl;
import org.guvnor.ala.docker.model.DockerProvider;
import org.guvnor.ala.docker.model.DockerRuntime;
import org.guvnor.ala.openshift.config.OpenShiftParameters;
import org.guvnor.ala.openshift.config.impl.OpenShiftProviderConfigImpl;
import org.guvnor.ala.openshift.config.impl.OpenShiftRuntimeConfigImpl;
import org.guvnor.ala.openshift.model.OpenShiftProvider;
import org.guvnor.ala.openshift.model.OpenShiftRuntime;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.services.api.RuntimeProvisioningService;
import org.guvnor.ala.services.api.itemlist.ProviderList;
import org.guvnor.ala.services.api.itemlist.ProviderTypeList;
import org.guvnor.ala.services.api.itemlist.RuntimeList;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.junit.Assert;
import org.junit.Ignore;

public class RuntimeEndpointsTestIT {
    private final String APP_URL = "http://localhost:8080/api/";

    @Ignore
    public void checkOpenShiftService() throws Exception {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://localhost:8080/api/");
        ResteasyWebTarget restEasyTarget = (ResteasyWebTarget)target;
        RuntimeProvisioningService proxy = (RuntimeProvisioningService)restEasyTarget.proxy(RuntimeProvisioningService.class);
        ProviderTypeList allProviderTypes = proxy.getProviderTypes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertNotNull((Object)allProviderTypes);
        Assert.assertEquals((long)3L, (long)allProviderTypes.getItems().size());
        OpenShiftProviderConfigImpl openshiftProviderConfig = this.createProviderConfig();
        proxy.registerProvider((ProviderConfig)openshiftProviderConfig);
        ProviderList allProviders = proxy.getProviders(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allProviders.getItems().size());
        Assert.assertTrue((boolean)(allProviders.getItems().get(0) instanceof OpenShiftProvider));
        OpenShiftProvider openshiftProvider = (OpenShiftProvider)allProviders.getItems().get(0);
        OpenShiftRuntimeConfigImpl runtimeConfig = this.createRuntimeConfig((ProviderId)openshiftProvider, "coss1");
        OpenShiftRuntime openshiftRuntime = this.getOpenShiftRuntime(proxy, 0, null);
        String runtimeId = proxy.newRuntime((RuntimeConfig)runtimeConfig);
        openshiftRuntime = this.getOpenShiftRuntime(proxy, 1, "READY");
        proxy.startRuntime(runtimeId);
        openshiftRuntime = this.getOpenShiftRuntime(proxy, 1, "RUNNING");
        proxy.stopRuntime(runtimeId);
        openshiftRuntime = this.getOpenShiftRuntime(proxy, 1, "READY");
        proxy.destroyRuntime(runtimeId, true);
        openshiftRuntime = this.getOpenShiftRuntime(proxy, 0, null);
    }

    private OpenShiftProviderConfigImpl createProviderConfig() {
        OpenShiftProviderConfigImpl openshiftProviderConfig = new OpenShiftProviderConfigImpl().clear();
        openshiftProviderConfig.setName(this.getClass().getSimpleName());
        openshiftProviderConfig.setKubernetesMaster("https://ce-os-rhel-master.usersys.redhat.com:8443");
        openshiftProviderConfig.setKubernetesAuthBasicUsername("admin");
        openshiftProviderConfig.setKubernetesAuthBasicPassword("admin");
        return openshiftProviderConfig;
    }

    private OpenShiftRuntimeConfigImpl createRuntimeConfig(ProviderId providerId, String testName) throws Exception {
        String prjName = this.createProjectName(testName);
        String appName = "myapp";
        String svcName = "myapp-execserv";
        OpenShiftRuntimeConfigImpl runtimeConfig = new OpenShiftRuntimeConfigImpl();
        runtimeConfig.setProviderId(providerId);
        runtimeConfig.setProjectName(prjName);
        runtimeConfig.setServiceName("myapp-execserv");
        runtimeConfig.setApplicationName("myapp");
        runtimeConfig.setResourceSecretsUri(this.getUri("bpmsuite-app-secret.json"));
        runtimeConfig.setResourceStreamsUri(this.getUri("bpmsuite-image-streams.json"));
        runtimeConfig.setResourceTemplateUri(this.getUri("bpmsuite70-execserv.json"));
        runtimeConfig.setResourceTemplateParamValues(new OpenShiftParameters().param("APPLICATION_NAME", "myapp").param("IMAGE_STREAM_NAMESPACE", prjName).param("KIE_ADMIN_PWD", "admin1!").param("KIE_SERVER_PWD", "execution1!").toString());
        return runtimeConfig;
    }

    private String createProjectName(String testName) {
        return System.getProperty("user.name", "anon").replaceAll("[^A-Za-z0-9]", "-") + '-' + (testName != null ? testName : "test") + '-' + new SimpleDateFormat("YYYYMMddHHmmss").format(new Date());
    }

    private String getUri(String resourcePath) throws URISyntaxException {
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        return this.getClass().getResource(resourcePath).toURI().toString();
    }

    private OpenShiftRuntime getOpenShiftRuntime(RuntimeProvisioningService proxy, int expectedCount, String expectedState) {
        RuntimeList allRuntimes = proxy.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)expectedCount, (long)allRuntimes.getItems().size());
        if (expectedCount == 0) {
            return null;
        }
        Runtime runtime = (Runtime)allRuntimes.getItems().get(0);
        Assert.assertTrue((boolean)(runtime instanceof OpenShiftRuntime));
        OpenShiftRuntime openshiftRuntime = (OpenShiftRuntime)runtime;
        Assert.assertEquals((Object)expectedState, (Object)openshiftRuntime.getState().getState());
        return openshiftRuntime;
    }

    @Ignore
    public void checkDockerService() {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://localhost:8080/api/");
        ResteasyWebTarget restEasyTarget = (ResteasyWebTarget)target;
        RuntimeProvisioningService proxy = (RuntimeProvisioningService)restEasyTarget.proxy(RuntimeProvisioningService.class);
        ProviderTypeList allProviderTypes = proxy.getProviderTypes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertNotNull((Object)allProviderTypes);
        Assert.assertEquals((long)3L, (long)allProviderTypes.getItems().size());
        DockerProviderConfigImpl dockerProviderConfig = new DockerProviderConfigImpl();
        proxy.registerProvider((ProviderConfig)dockerProviderConfig);
        ProviderList allProviders = proxy.getProviders(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allProviders.getItems().size());
        Assert.assertTrue((boolean)(allProviders.getItems().get(0) instanceof DockerProvider));
        DockerProvider dockerProvider = (DockerProvider)allProviders.getItems().get(0);
        DockerRuntimeConfigImpl runtimeConfig = new DockerRuntimeConfigImpl((ProviderId)dockerProvider, "kitematic/hello-world-nginx", "8080", true);
        RuntimeList allRuntimes = proxy.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)0L, (long)allRuntimes.getItems().size());
        String newRuntime = proxy.newRuntime((RuntimeConfig)runtimeConfig);
        allRuntimes = proxy.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.getItems().size());
        Runtime runtime = (Runtime)allRuntimes.getItems().get(0);
        Assert.assertTrue((boolean)(runtime instanceof DockerRuntime));
        DockerRuntime dockerRuntime = (DockerRuntime)runtime;
        Assert.assertEquals((Object)"Running", (Object)dockerRuntime.getState().getState());
        proxy.stopRuntime(newRuntime);
        allRuntimes = proxy.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.getItems().size());
        runtime = (Runtime)allRuntimes.getItems().get(0);
        Assert.assertTrue((boolean)(runtime instanceof DockerRuntime));
        dockerRuntime = (DockerRuntime)runtime;
        Assert.assertEquals((Object)"Stopped", (Object)dockerRuntime.getState().getState());
        proxy.destroyRuntime(newRuntime, true);
        allRuntimes = proxy.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)0L, (long)allRuntimes.getItems().size());
    }
}

