/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.JobSpec;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonAnyGetter;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonAnySetter;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonIgnore;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonInclude;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonProperty;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonPropertyOrder;
import org.kie.workbench.ala.openshift.jackson.databind.JsonDeserializer;
import org.kie.workbench.ala.openshift.jackson.databind.annotation.JsonDeserialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class JobTemplateSpec
implements KubernetesResource {
    @JsonProperty(value="metadata")
    @Valid
    @CheckObjectMeta(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$", max=253)
    private ObjectMeta metadata;
    @JsonProperty(value="spec")
    @Valid
    private JobSpec spec;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public JobTemplateSpec() {
    }

    public JobTemplateSpec(ObjectMeta metadata, JobSpec spec) {
        this.metadata = metadata;
        this.spec = spec;
    }

    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="spec")
    public JobSpec getSpec() {
        return this.spec;
    }

    @JsonProperty(value="spec")
    public void setSpec(JobSpec spec) {
        this.spec = spec;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "JobTemplateSpec(metadata=" + this.getMetadata() + ", spec=" + this.getSpec() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobTemplateSpec)) {
            return false;
        }
        JobTemplateSpec other = (JobTemplateSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        JobSpec this$spec = this.getSpec();
        JobSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobTemplateSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        JobSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

