/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceFluent;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathBuilder;
import io.fabric8.openshift.api.model.ImageSourcePathFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageSourceFluentImpl<A extends ImageSourceFluent<A>>
extends BaseFluent<A>
implements ImageSourceFluent<A> {
    private ObjectReferenceBuilder from;
    private List<ImageSourcePathBuilder> paths = new ArrayList<ImageSourcePathBuilder>();
    private LocalObjectReferenceBuilder pullSecret;

    public ImageSourceFluentImpl() {
    }

    public ImageSourceFluentImpl(ImageSource instance) {
        this.withFrom(instance.getFrom());
        this.withPaths(instance.getPaths());
        this.withPullSecret(instance.getPullSecret());
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public ImageSourceFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public ImageSourceFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public ImageSourceFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public ImageSourceFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public ImageSourceFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public A addToPaths(int index, ImageSourcePath item) {
        ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.paths.add(index >= 0 ? index : this.paths.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPaths(int index, ImageSourcePath item) {
        ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.paths.size()) {
            this.paths.add(builder);
        } else {
            this.paths.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPaths(ImageSourcePath ... items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<ImageSourcePath> items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(ImageSourcePath ... items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.remove(builder);
            this.paths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<ImageSourcePath> items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.remove(builder);
            this.paths.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageSourcePath> getPaths() {
        return ImageSourceFluentImpl.build(this.paths);
    }

    @Override
    public List<ImageSourcePath> buildPaths() {
        return ImageSourceFluentImpl.build(this.paths);
    }

    @Override
    public ImageSourcePath buildPath(int index) {
        return this.paths.get(index).build();
    }

    @Override
    public ImageSourcePath buildFirstPath() {
        return this.paths.get(0).build();
    }

    @Override
    public ImageSourcePath buildLastPath() {
        return this.paths.get(this.paths.size() - 1).build();
    }

    @Override
    public ImageSourcePath buildMatchingPath(Predicate<ImageSourcePathBuilder> predicate) {
        for (ImageSourcePathBuilder item : this.paths) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withPaths(List<ImageSourcePath> paths) {
        this._visitables.removeAll(this.paths);
        this.paths.clear();
        if (paths != null) {
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPaths(ImageSourcePath ... paths) {
        this.paths.clear();
        if (paths != null) {
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public ImageSourceFluent.PathsNested<A> addNewPath() {
        return new PathsNestedImpl();
    }

    @Override
    public ImageSourceFluent.PathsNested<A> addNewPathLike(ImageSourcePath item) {
        return new PathsNestedImpl(-1, item);
    }

    @Override
    public ImageSourceFluent.PathsNested<A> setNewPathLike(int index, ImageSourcePath item) {
        return new PathsNestedImpl(index, item);
    }

    @Override
    public ImageSourceFluent.PathsNested<A> editPath(int index) {
        if (this.paths.size() <= index) {
            throw new RuntimeException("Can't edit paths. Index exceeds size.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public ImageSourceFluent.PathsNested<A> editFirstPath() {
        if (this.paths.size() == 0) {
            throw new RuntimeException("Can't edit first paths. The list is empty.");
        }
        return this.setNewPathLike(0, this.buildPath(0));
    }

    @Override
    public ImageSourceFluent.PathsNested<A> editLastPath() {
        int index = this.paths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last paths. The list is empty.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public ImageSourceFluent.PathsNested<A> editMatchingPath(Predicate<ImageSourcePathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.paths.size(); ++i) {
            if (!predicate.apply(this.paths.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching paths. No match found.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public A addNewPath(String destinationDir, String sourcePath) {
        return this.addToPaths(new ImageSourcePath(destinationDir, sourcePath));
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : item);
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSourceFluentImpl that = (ImageSourceFluentImpl)o;
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        return !(this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null);
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ImageSourceFluent.PullSecretNested<N>>
    implements ImageSourceFluent.PullSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class PathsNestedImpl<N>
    extends ImageSourcePathFluentImpl<ImageSourceFluent.PathsNested<N>>
    implements ImageSourceFluent.PathsNested<N>,
    Nested<N> {
        private final ImageSourcePathBuilder builder;
        private final int index;

        PathsNestedImpl(int index, ImageSourcePath item) {
            this.index = index;
            this.builder = new ImageSourcePathBuilder(this, item);
        }

        PathsNestedImpl() {
            this.index = -1;
            this.builder = new ImageSourcePathBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.setToPaths(this.index, this.builder.build());
        }

        @Override
        public N endPath() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<ImageSourceFluent.FromNested<N>>
    implements ImageSourceFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

