/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.ala.openshift.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.kie.workbench.ala.openshift.jackson.annotation.JsonFormat;
import org.kie.workbench.ala.openshift.jackson.core.JsonGenerator;
import org.kie.workbench.ala.openshift.jackson.core.JsonParser;
import org.kie.workbench.ala.openshift.jackson.databind.BeanProperty;
import org.kie.workbench.ala.openshift.jackson.databind.JavaType;
import org.kie.workbench.ala.openshift.jackson.databind.JsonMappingException;
import org.kie.workbench.ala.openshift.jackson.databind.JsonNode;
import org.kie.workbench.ala.openshift.jackson.databind.JsonSerializer;
import org.kie.workbench.ala.openshift.jackson.databind.SerializerProvider;
import org.kie.workbench.ala.openshift.jackson.databind.annotation.JacksonStdImpl;
import org.kie.workbench.ala.openshift.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.kie.workbench.ala.openshift.jackson.databind.ser.ContextualSerializer;
import org.kie.workbench.ala.openshift.jackson.databind.ser.std.StdScalarSerializer;
import org.kie.workbench.ala.openshift.jackson.databind.ser.std.ToStringSerializer;

@JacksonStdImpl
public class NumberSerializer
extends StdScalarSerializer<Number>
implements ContextualSerializer {
    public static final NumberSerializer instance = new NumberSerializer((Class<? extends Number>)Number.class);
    protected final boolean _isInt;

    public NumberSerializer(Class<? extends Number> rawType) {
        super(rawType, false);
        this._isInt = rawType == BigInteger.class;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(prov, property, this.handledType());
        if (format != null) {
            switch (format.getShape()) {
                case STRING: {
                    return ToStringSerializer.instance;
                }
            }
        }
        return this;
    }

    @Override
    public void serialize(Number value, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (value instanceof BigDecimal) {
            g.writeNumber((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            g.writeNumber((BigInteger)value);
        } else if (value instanceof Long) {
            g.writeNumber(value.longValue());
        } else if (value instanceof Double) {
            g.writeNumber(value.doubleValue());
        } else if (value instanceof Float) {
            g.writeNumber(value.floatValue());
        } else if (value instanceof Integer || value instanceof Byte || value instanceof Short) {
            g.writeNumber(value.intValue());
        } else {
            g.writeNumber(value.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._isInt ? "integer" : "number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this._isInt) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.BIG_INTEGER);
        } else {
            Class h = this.handledType();
            if (h == BigDecimal.class) {
                this.visitFloatFormat(visitor, typeHint, JsonParser.NumberType.BIG_DECIMAL);
            } else {
                visitor.expectNumberFormat(typeHint);
            }
        }
    }
}

