/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.ala.openshift.jackson.databind.ser;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.workbench.ala.openshift.jackson.databind.JavaType;
import org.kie.workbench.ala.openshift.jackson.databind.JsonMappingException;
import org.kie.workbench.ala.openshift.jackson.databind.JsonSerializer;
import org.kie.workbench.ala.openshift.jackson.databind.SerializerProvider;
import org.kie.workbench.ala.openshift.jackson.databind.ser.ResolvableSerializer;
import org.kie.workbench.ala.openshift.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;

public final class SerializerCache {
    private final HashMap<org.kie.workbench.ala.openshift.jackson.databind.util.TypeKey, JsonSerializer<Object>> _sharedMap = new HashMap(64);
    private final AtomicReference<ReadOnlyClassToSerializerMap> _readOnlyMap = new AtomicReference();

    public ReadOnlyClassToSerializerMap getReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap m = this._readOnlyMap.get();
        if (m != null) {
            return m;
        }
        return this._makeReadOnlyLookupMap();
    }

    private final synchronized ReadOnlyClassToSerializerMap _makeReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap m = this._readOnlyMap.get();
        if (m == null) {
            m = ReadOnlyClassToSerializerMap.from(this._sharedMap);
            this._readOnlyMap.set(m);
        }
        return m;
    }

    public synchronized int size() {
        return this._sharedMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(Class<?> type) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(type, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(JavaType type) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(type, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(JavaType type) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(type, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(Class<?> cls) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(cls, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedSerializer(JavaType type, JsonSerializer<Object> ser) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(type, true), ser) == null) {
                this._readOnlyMap.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedSerializer(Class<?> cls, JsonSerializer<Object> ser) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(cls, true), ser) == null) {
                this._readOnlyMap.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(Class<?> type, JsonSerializer<Object> ser, SerializerProvider provider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(type, false), ser) == null) {
                this._readOnlyMap.set(null);
            }
            if (ser instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)ser)).resolve(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(JavaType type, JsonSerializer<Object> ser, SerializerProvider provider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(type, false), ser) == null) {
                this._readOnlyMap.set(null);
            }
            if (ser instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)ser)).resolve(provider);
            }
        }
    }

    public synchronized void flush() {
        this._sharedMap.clear();
    }

    @Deprecated
    public static final class TypeKey
    extends org.kie.workbench.ala.openshift.jackson.databind.util.TypeKey {
        public TypeKey(Class<?> key, boolean typed) {
            super(key, typed);
        }

        public TypeKey(JavaType key, boolean typed) {
            super(key, typed);
        }
    }
}

