/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.ala.openshift.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.Map;
import org.kie.workbench.ala.openshift.jackson.core.JsonGenerationException;
import org.kie.workbench.ala.openshift.jackson.core.JsonGenerator;
import org.kie.workbench.ala.openshift.jackson.databind.AnnotationIntrospector;
import org.kie.workbench.ala.openshift.jackson.databind.BeanProperty;
import org.kie.workbench.ala.openshift.jackson.databind.JavaType;
import org.kie.workbench.ala.openshift.jackson.databind.JsonMappingException;
import org.kie.workbench.ala.openshift.jackson.databind.JsonSerializer;
import org.kie.workbench.ala.openshift.jackson.databind.SerializationFeature;
import org.kie.workbench.ala.openshift.jackson.databind.SerializerProvider;
import org.kie.workbench.ala.openshift.jackson.databind.annotation.JacksonStdImpl;
import org.kie.workbench.ala.openshift.jackson.databind.introspect.AnnotatedMember;
import org.kie.workbench.ala.openshift.jackson.databind.jsontype.TypeSerializer;
import org.kie.workbench.ala.openshift.jackson.databind.ser.ContainerSerializer;
import org.kie.workbench.ala.openshift.jackson.databind.ser.ContextualSerializer;
import org.kie.workbench.ala.openshift.jackson.databind.ser.impl.PropertySerializerMap;

@JacksonStdImpl
public class MapEntrySerializer
extends ContainerSerializer<Map.Entry<?, ?>>
implements ContextualSerializer {
    protected final BeanProperty _property;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _entryType;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;

    public MapEntrySerializer(JavaType type, JavaType keyType, JavaType valueType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
        super(type);
        this._entryType = type;
        this._keyType = keyType;
        this._valueType = valueType;
        this._valueTypeIsStatic = staticTyping;
        this._valueTypeSerializer = vts;
        this._property = property;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected MapEntrySerializer(MapEntrySerializer src, BeanProperty property, TypeSerializer vts, JsonSerializer<?> keySer, JsonSerializer<?> valueSer) {
        super(Map.class, false);
        this._entryType = src._entryType;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._keySerializer = keySer;
        this._valueSerializer = valueSer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._property = src._property;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new MapEntrySerializer(this, this._property, vts, this._keySerializer, this._valueSerializer);
    }

    public MapEntrySerializer withResolved(BeanProperty property, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer) {
        return new MapEntrySerializer(this, property, this._valueTypeSerializer, keySerializer, valueSerializer);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        AnnotatedMember propertyAcc;
        JsonSerializer<Object> ser = null;
        JsonSerializer<Object> keySer = null;
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        AnnotatedMember annotatedMember = propertyAcc = property == null ? null : property.getMember();
        if (propertyAcc != null && intr != null) {
            Object serDef = intr.findKeySerializer(propertyAcc);
            if (serDef != null) {
                keySer = provider.serializerInstance(propertyAcc, serDef);
            }
            if ((serDef = intr.findContentSerializer(propertyAcc)) != null) {
                ser = provider.serializerInstance(propertyAcc, serDef);
            }
        }
        if (ser == null) {
            ser = this._valueSerializer;
        }
        if ((ser = this.findConvertingContentSerializer(provider, property, ser)) == null) {
            if (this._valueTypeIsStatic && this._valueType.getRawClass() != Object.class || this.hasContentTypeAnnotation(provider, property)) {
                ser = provider.findValueSerializer(this._valueType, property);
            }
        } else {
            ser = provider.handleSecondaryContextualization(ser, property);
        }
        if (keySer == null) {
            keySer = this._keySerializer;
        }
        keySer = keySer == null ? provider.findKeySerializer(this._keyType, property) : provider.handleSecondaryContextualization(keySer, property);
        MapEntrySerializer mser = this.withResolved(property, keySer, ser);
        return mser;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean hasSingleElement(Map.Entry<?, ?> value) {
        return true;
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Map.Entry<?, ?> value) {
        return value == null;
    }

    @Override
    public void serialize(Map.Entry<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.setCurrentValue(value);
        if (this._valueSerializer != null) {
            this.serializeUsing(value, gen, provider, this._valueSerializer);
        } else {
            this.serializeDynamic(value, gen, provider);
        }
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Map.Entry<?, ?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject(value, gen);
        gen.setCurrentValue(value);
        if (this._valueSerializer != null) {
            this.serializeUsing(value, gen, provider, this._valueSerializer);
        } else {
            this.serializeDynamic(value, gen, provider);
        }
        typeSer.writeTypeSuffixForObject(value, gen);
    }

    protected void serializeDynamic(Map.Entry<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        JsonSerializer<Object> keySerializer = this._keySerializer;
        boolean skipNulls = !provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        TypeSerializer vts = this._valueTypeSerializer;
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        Object valueElem = value.getValue();
        Object keyElem = value.getKey();
        if (keyElem == null) {
            provider.findNullKeySerializer(this._keyType, this._property).serialize(null, jgen, provider);
        } else {
            if (skipNulls && valueElem == null) {
                return;
            }
            keySerializer.serialize(keyElem, jgen, provider);
        }
        if (valueElem == null) {
            provider.defaultSerializeNull(jgen);
        } else {
            Class<?> cc = valueElem.getClass();
            JsonSerializer<Object> ser = serializers.serializerFor(cc);
            if (ser == null) {
                ser = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._valueType, cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                serializers = this._dynamicValueSerializers;
            }
            try {
                if (vts == null) {
                    ser.serialize(valueElem, jgen, provider);
                } else {
                    ser.serializeWithType(valueElem, jgen, provider, vts);
                }
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    protected void serializeUsing(Map.Entry<?, ?> value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
        JsonSerializer<Object> keySerializer = this._keySerializer;
        TypeSerializer vts = this._valueTypeSerializer;
        boolean skipNulls = !provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        Object valueElem = value.getValue();
        Object keyElem = value.getKey();
        if (keyElem == null) {
            provider.findNullKeySerializer(this._keyType, this._property).serialize(null, jgen, provider);
        } else {
            if (skipNulls && valueElem == null) {
                return;
            }
            keySerializer.serialize(keyElem, jgen, provider);
        }
        if (valueElem == null) {
            provider.defaultSerializeNull(jgen);
        } else {
            try {
                if (vts == null) {
                    ser.serialize(valueElem, jgen, provider);
                } else {
                    ser.serializeWithType(valueElem, jgen, provider, vts);
                }
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, JavaType type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }
}

