/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zjsonpatch;

import io.fabric8.zjsonpatch.internal.guava.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import org.kie.workbench.ala.openshift.jackson.core.JsonToken;
import org.kie.workbench.ala.openshift.jackson.databind.JsonNode;

enum NodeType {
    ARRAY("array"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    NULL("null"),
    NUMBER("number"),
    OBJECT("object"),
    STRING("string");

    private final String name;
    private static final Map<JsonToken, NodeType> TOKEN_MAP;

    private NodeType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static NodeType getNodeType(JsonNode node) {
        JsonToken token = node.asToken();
        NodeType ret = TOKEN_MAP.get((Object)token);
        Preconditions.checkNotNull(ret, "unhandled token type " + (Object)((Object)token), new Object[0]);
        return ret;
    }

    static {
        TOKEN_MAP = new EnumMap<JsonToken, NodeType>(JsonToken.class);
        TOKEN_MAP.put(JsonToken.START_ARRAY, ARRAY);
        TOKEN_MAP.put(JsonToken.VALUE_TRUE, BOOLEAN);
        TOKEN_MAP.put(JsonToken.VALUE_FALSE, BOOLEAN);
        TOKEN_MAP.put(JsonToken.VALUE_NUMBER_INT, INTEGER);
        TOKEN_MAP.put(JsonToken.VALUE_NUMBER_FLOAT, NUMBER);
        TOKEN_MAP.put(JsonToken.VALUE_NULL, NULL);
        TOKEN_MAP.put(JsonToken.START_OBJECT, OBJECT);
        TOKEN_MAP.put(JsonToken.VALUE_STRING, STRING);
    }
}

