/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.dns;

import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import sun.net.spi.nameservice.NameService;

public class OpenShiftNameService
implements NameService {
    private static final Map<String, InetAddress> ROUTING = Collections.synchronizedMap(new TreeMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRoutes(RouteList routeList, String routerHost) {
        InetAddress routerAddr;
        try {
            routerAddr = routerHost == null ? null : InetAddress.getByName(routerHost);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP for router host", e);
        }
        if (routeList != null) {
            Map<String, InetAddress> map = ROUTING;
            synchronized (map) {
                for (Route route : routeList.getItems()) {
                    String host = route.getSpec().getHost();
                    if (routerAddr != null) {
                        System.out.println(String.format("Adding route (router -> host): %s -> %s", routerHost, host));
                        ROUTING.put(host, routerAddr);
                        continue;
                    }
                    ROUTING.remove(host);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getHosts() {
        Map<String, InetAddress> map = ROUTING;
        synchronized (map) {
            return Collections.unmodifiableSet(ROUTING.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHostRegistered(String host) {
        Map<String, InetAddress> map = ROUTING;
        synchronized (map) {
            return ROUTING.containsKey(host);
        }
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        Map<String, InetAddress> map = ROUTING;
        synchronized (map) {
            InetAddress routerAddr;
            if (host != null && (routerAddr = ROUTING.get(host)) != null) {
                return new InetAddress[]{InetAddress.getByAddress(host, routerAddr.getAddress())};
            }
            throw new UnknownHostException(host);
        }
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        throw new UnknownHostException();
    }
}

