/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.access;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.Loadable;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.DoneableTemplate;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.guvnor.ala.openshift.access.OpenShiftClient;
import org.guvnor.ala.openshift.access.exceptions.OpenShiftClientException;
import org.guvnor.ala.openshift.config.OpenShiftRuntimeConfig;

@JsonIgnoreType
public class OpenShiftTemplate {
    private final TemplateResource<Template, KubernetesList, DoneableTemplate> resource;
    private final Template template;

    public OpenShiftTemplate(OpenShiftClient client, OpenShiftRuntimeConfig runtimeConfig) {
        Object loadable = null;
        String prjName = runtimeConfig.getProjectName();
        String templateUri = runtimeConfig.getResourceTemplateUri();
        String templateName = runtimeConfig.getResourceTemplateName();
        loadable = prjName != null ? (Loadable)client.getDelegate().templates().inNamespace(prjName) : client.getDelegate().templates();
        TemplateResource res = null;
        if (templateUri != null) {
            URL templateUrl = client.toUrl(templateUri);
            if (templateUrl != null) {
                res = (TemplateResource)loadable.load(templateUrl);
            }
        } else if (templateName != null && !templateName.isEmpty()) {
            res = (TemplateResource)loadable.load(templateName);
        }
        this.resource = res;
        Template template = this.template = res != null ? (Template)res.get() : null;
        if (this.template == null) {
            throw new OpenShiftClientException(String.format("could not load template with project [%s] and uri [%s] or name [%s]", prjName, templateUri, templateName));
        }
    }

    public OpenShiftTemplate(File templateFile) {
        this(templateFile.toURI());
    }

    public OpenShiftTemplate(String templateUri) {
        this(URI.create(templateUri));
    }

    public OpenShiftTemplate(URI templateUri) {
        this.resource = null;
        try {
            InputStream templateStream = templateUri.toURL().openStream();
            this.template = this.load(templateStream);
            templateStream.close();
        }
        catch (IOException ioe) {
            throw new OpenShiftClientException(ioe.getMessage(), ioe);
        }
        if (this.template == null) {
            throw new OpenShiftClientException(String.format("could not load template with uri [%s]", templateUri));
        }
    }

    public OpenShiftTemplate(URL templateUrl) {
        this.resource = null;
        try {
            InputStream templateStream = templateUrl.openStream();
            this.template = this.load(templateStream);
            templateStream.close();
        }
        catch (IOException ioe) {
            throw new OpenShiftClientException(ioe.getMessage(), ioe);
        }
        if (this.template == null) {
            throw new OpenShiftClientException(String.format("could not load template with url [%s]", templateUrl));
        }
    }

    public OpenShiftTemplate(InputStream templateStream) {
        this.resource = null;
        this.template = this.load(templateStream);
    }

    private Template load(InputStream templateStream) {
        String generatedName = Utils.randomString((String)"template-", (int)10);
        Template temp = null;
        Object item = Serialization.unmarshal((InputStream)templateStream);
        if (item instanceof Template) {
            temp = (Template)item;
        } else if (item instanceof HasMetadata) {
            HasMetadata h = (HasMetadata)item;
            temp = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).withNamespace(h != null && h.getMetadata() != null ? h.getMetadata().getNamespace() : null)).endMetadata()).withObjects(new HasMetadata[]{h})).build();
        } else if (item instanceof KubernetesResourceList) {
            List list = ((KubernetesResourceList)item).getItems();
            temp = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).endMetadata()).withObjects(list.toArray(new HasMetadata[list.size()]))).build();
        } else if (item instanceof HasMetadata[]) {
            temp = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).endMetadata()).withObjects((HasMetadata[])item)).build();
        } else if (item instanceof Collection) {
            ArrayList<HasMetadata> items = new ArrayList<HasMetadata>();
            for (Object o : (Collection)item) {
                if (!(o instanceof HasMetadata)) continue;
                items.add((HasMetadata)o);
            }
            temp = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).endMetadata()).withObjects(items.toArray(new HasMetadata[items.size()]))).build();
        }
        return temp;
    }

    public Collection<Parameter> getParameters() {
        return this.getParameterMap().values();
    }

    public SortedMap<String, Parameter> getParameterMap() {
        TreeMap<String, Parameter> map = new TreeMap<String, Parameter>();
        if (this.template != null) {
            List list = this.template.getParameters();
            for (io.fabric8.openshift.api.model.Parameter param : list) {
                map.put(param.getName(), new Parameter(param));
            }
        }
        return map;
    }

    KubernetesList process(Map<String, String> parameters) {
        if (this.resource != null) {
            return (KubernetesList)this.resource.process(parameters);
        }
        throw new IllegalStateException("cannot process parameters with null template resource");
    }

    @JsonIgnoreType
    public class Parameter {
        private final io.fabric8.openshift.api.model.Parameter param;

        private Parameter(io.fabric8.openshift.api.model.Parameter param) {
            this.param = param;
        }

        public String getName() {
            return this.param.getName();
        }

        public String getDisplayName() {
            return this.param.getDisplayName();
        }

        public String getDescription() {
            return this.param.getDescription();
        }

        public boolean isRequired() {
            Boolean b = this.param.getRequired();
            return b != null && b != false;
        }

        public String getGenerate() {
            return this.param.getGenerate();
        }

        public String getFrom() {
            return this.param.getFrom();
        }

        public String getValue() {
            return this.param.getValue();
        }
    }
}

