/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.provider;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import org.guvnor.ala.ui.client.util.ContentChangeHandler;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.openshift.client.provider.OpenShiftProviderConfigPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class OpenShiftProviderConfigPresenterTest {
    private static final String PROVIDER_NAME_VALUE = "PROVIDER_NAME_VALUE";
    private static final String MASTER_URL_VALUE = "MASTER_URL_VALUE";
    private static final String USER_VALUE = "USER_VALUE";
    private static final String PASSWORD_VALUE = "PASSWORD_VALUE";
    @Mock
    private OpenShiftProviderConfigPresenter.View view;
    private OpenShiftProviderConfigPresenter presenter;
    @Mock
    private ContentChangeHandler changeHandler;

    @Before
    public void setUp() {
        this.presenter = new OpenShiftProviderConfigPresenter(this.view);
        this.presenter.init();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        this.presenter.addContentChangeHandler(this.changeHandler);
    }

    @Test
    public void testBuildProviderConfiguration() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        Mockito.when((Object)this.view.getMasterURL()).thenReturn((Object)MASTER_URL_VALUE);
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USER_VALUE);
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD_VALUE);
        ProviderConfiguration configuration = this.presenter.buildProviderConfiguration();
        Assert.assertEquals((Object)PROVIDER_NAME_VALUE, (Object)this.presenter.getProviderName());
        Assert.assertEquals((Object)MASTER_URL_VALUE, configuration.getValues().get("kubernetes-master"));
        Assert.assertEquals((Object)USER_VALUE, configuration.getValues().get("kubernetes-auth-basic-username"));
        Assert.assertEquals((Object)PASSWORD_VALUE, configuration.getValues().get("kubernetes-auth-basic-password"));
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testLoad() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("kubernetes-master", MASTER_URL_VALUE);
        values.put("kubernetes-auth-basic-username", USER_VALUE);
        values.put("kubernetes-auth-basic-password", PASSWORD_VALUE);
        Provider provider = (Provider)Mockito.mock(Provider.class);
        ProviderKey providerKey = (ProviderKey)Mockito.mock(ProviderKey.class);
        ProviderConfiguration configuration = (ProviderConfiguration)Mockito.mock(ProviderConfiguration.class);
        Mockito.when((Object)provider.getKey()).thenReturn((Object)providerKey);
        Mockito.when((Object)providerKey.getId()).thenReturn((Object)PROVIDER_NAME_VALUE);
        Mockito.when((Object)provider.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.getValues()).thenReturn(values);
        this.presenter.load(provider);
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProviderName(PROVIDER_NAME_VALUE);
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setMasterURL(MASTER_URL_VALUE);
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setUsername(USER_VALUE);
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPassword(PASSWORD_VALUE);
    }

    @Test
    public void testGetProviderName() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        Assert.assertEquals((Object)PROVIDER_NAME_VALUE, (Object)this.presenter.getProviderName());
    }

    @Test
    public void testGetMasterURL() {
        Mockito.when((Object)this.view.getMasterURL()).thenReturn((Object)MASTER_URL_VALUE);
        Assert.assertEquals((Object)MASTER_URL_VALUE, (Object)this.presenter.getMasterURL());
    }

    @Test
    public void testGetUser() {
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USER_VALUE);
        Assert.assertEquals((Object)USER_VALUE, (Object)this.presenter.getUsername());
    }

    @Test
    public void testGetPassword() {
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD_VALUE);
        Assert.assertEquals((Object)PASSWORD_VALUE, (Object)this.presenter.getPassword());
    }

    @Test
    public void testIsValid() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getMasterURL()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)"");
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getMasterURL()).thenReturn((Object)MASTER_URL_VALUE);
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USER_VALUE);
        this.presenter.isValid(Assert::assertFalse);
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD_VALUE);
        this.presenter.isValid(Assert::assertTrue);
    }

    @Test
    public void testDisable() {
        this.presenter.disable();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).disable();
    }

    @Test
    public void testOnProviderNameChangeValid() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)PROVIDER_NAME_VALUE);
        this.presenter.onProviderNameChange();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProviderNameStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnProviderNameChangeInvalid() {
        Mockito.when((Object)this.view.getProviderName()).thenReturn((Object)"");
        this.presenter.onProviderNameChange();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProviderNameStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnMasterURLChangeValid() {
        Mockito.when((Object)this.view.getMasterURL()).thenReturn((Object)MASTER_URL_VALUE);
        this.presenter.onMasterURLChange();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setMasterURLStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnMasterURLChangeInvalid() {
        Mockito.when((Object)this.view.getMasterURL()).thenReturn((Object)"");
        this.presenter.onMasterURLChange();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setMasterURLStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnUserChangeValid() {
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)USER_VALUE);
        this.presenter.onUserNameChange();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setUsernameStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnUserChangeInvalid() {
        Mockito.when((Object)this.view.getUsername()).thenReturn((Object)"");
        this.presenter.onUserNameChange();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setUsernameStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnPasswordChangeValid() {
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)PASSWORD_VALUE);
        this.presenter.onPasswordChange();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPasswordStatus(FormStatus.VALID);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnPasswordChangeInvalid() {
        Mockito.when((Object)this.view.getPassword()).thenReturn((Object)"");
        this.presenter.onPasswordChange();
        ((OpenShiftProviderConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPasswordStatus(FormStatus.ERROR);
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }
}

