/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.pipeline.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.util.AbstractHasContentChangeHandlers;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfig;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigParamsChangeEvent;
import org.guvnor.ala.ui.client.wizard.pipeline.params.PipelineParamsForm;
import org.guvnor.ala.ui.openshift.client.pipeline.template.table.TemplateParamsTablePresenter;
import org.guvnor.ala.ui.openshift.client.validation.OpenShiftClientValidationService;
import org.guvnor.ala.ui.openshift.model.DefaultSettings;
import org.guvnor.ala.ui.openshift.model.TemplateDescriptorModel;
import org.guvnor.ala.ui.openshift.model.TemplateParam;
import org.guvnor.ala.ui.openshift.service.OpenShiftClientService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;

@ApplicationScoped
public class TemplateParamsFormPresenter
extends AbstractHasContentChangeHandlers
implements PipelineParamsForm {
    public static final String PARAM_DELIMITER = ",";
    public static final String PARAM_ASSIGNER = "=";
    public static final String CONTAINER_DELIMITER = "|";
    public static final String RESOURCE_TEMPLATE_PARAM_VALUES = "resource-template-param-values";
    public static final String RESOURCE_TEMPLATE_URI = "resource-template-uri";
    public static final String RESOURCE_SECRETS_URI = "resource-secrets-uri";
    public static final String RESOURCE_STREAMS_URI = "resource-streams-uri";
    public static final String APPLICATION_NAME = "application-name";
    public static final String PROJECT_NAME = "project-name";
    public static final String SERVICE_NAME = "service-name";
    public static final String KIE_SERVER_CONTAINER_DEPLOYMENT = "org-kie-server-container-deployment";
    public static final String IMAGE_STREAM_NAMESPACE_TEMPLATE_PARAM = "IMAGE_STREAM_NAMESPACE";
    public static final String APPLICATION_NAME_TEMPLATE_PARAM = "APPLICATION_NAME";
    public static final String SERVICE_NAME_SUFFIX = "-execserv";
    public static final String HORNETQ_QUEUES = "HORNETQ_QUEUES";
    public static final String HORNETQ_TOPICS = "HORNETQ_TOPICS";
    public static final String HORNETQ_CLUSTER_PASSWORD = "HORNETQ_CLUSTER_PASSWORD";
    private static final Set<String> bannedParameters = new HashSet<String>();
    private final View view;
    private TemplateParamsTablePresenter paramsEditorPresenter;
    private final TranslationService translationService;
    private final PopupHelper popupHelper;
    private final Caller<OpenShiftClientService> openShiftClientService;
    private final OpenShiftClientValidationService openShiftClientValidationService;
    private List<TemplateParam> params = new ArrayList<TemplateParam>();
    private boolean runtimeNameValid = false;
    private boolean templateLoaded = false;
    private List<ContainerConfig> configuredContainers;

    @Inject
    public TemplateParamsFormPresenter(View view, TemplateParamsTablePresenter paramsEditorPresenter, TranslationService translationService, PopupHelper popupHelper, Caller<OpenShiftClientService> openShiftClientService, OpenShiftClientValidationService openShiftClientValidationService) {
        this.view = view;
        this.paramsEditorPresenter = paramsEditorPresenter;
        this.translationService = translationService;
        this.popupHelper = popupHelper;
        this.openShiftClientService = openShiftClientService;
        this.openShiftClientValidationService = openShiftClientValidationService;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
        this.view.setParamsEditorPresenter((IsElement)this.paramsEditorPresenter.getView());
        this.paramsEditorPresenter.setParamChangeHandler((paramName, newValue, oldValue) -> this.onParamChange());
    }

    public String getWizardTitle() {
        return this.view.getWizardTitle();
    }

    public View getView() {
        return this.view;
    }

    public Map<String, String> buildParams() {
        String runtimeName;
        HashMap<String, String> pipelineParams = new HashMap<String, String>();
        String projectName = runtimeName = this.getRuntimeName();
        String applicationName = runtimeName;
        String serviceName = runtimeName + SERVICE_NAME_SUFFIX;
        String imageStreamNamespace = projectName;
        pipelineParams.put("runtime-name", runtimeName);
        pipelineParams.put(PROJECT_NAME, projectName);
        pipelineParams.put(APPLICATION_NAME, applicationName);
        pipelineParams.put(SERVICE_NAME, serviceName);
        pipelineParams.put(RESOURCE_TEMPLATE_URI, this.getTemplateURL());
        pipelineParams.put(RESOURCE_STREAMS_URI, this.getImageStreamsURL());
        pipelineParams.put(RESOURCE_SECRETS_URI, this.getSecretsFileURL());
        if (this.configuredContainers != null && !this.configuredContainers.isEmpty()) {
            pipelineParams.put(KIE_SERVER_CONTAINER_DEPLOYMENT, this.buildContainerDeploymentParamValue(this.configuredContainers));
        }
        StringBuilder builder = new StringBuilder();
        this.params.forEach(param -> {
            if (!this.isBanned(param.getName()) && !this.isEmpty(param.getValue())) {
                this.addTemplateParam(builder, param.getName(), param.getValue());
            }
        });
        this.addTemplateParam(builder, IMAGE_STREAM_NAMESPACE_TEMPLATE_PARAM, imageStreamNamespace);
        this.addTemplateParam(builder, APPLICATION_NAME_TEMPLATE_PARAM, applicationName);
        pipelineParams.put(RESOURCE_TEMPLATE_PARAM_VALUES, builder.toString());
        return pipelineParams;
    }

    public void initialise() {
        this.templateLoaded = false;
        ((OpenShiftClientService)this.openShiftClientService.call(this.getDefaultSettingsSuccessCallback(), this.popupHelper.getPopupErrorCallback())).getDefaultSettings();
    }

    public void prepareView() {
        this.paramsEditorPresenter.getView().redraw();
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean isValid = this.isRuntimeValid() && this.isTemplateValid() && this.isParamsValid() && this.isImageStreamsURLValid() && this.isSecretsFileURLValid();
        callback.callback((Object)isValid);
    }

    public void clear() {
        this.runtimeNameValid = false;
        this.clearParams();
        this.view.clear();
    }

    private RemoteCallback<DefaultSettings> getDefaultSettingsSuccessCallback() {
        return defaultSettings -> {
            String templateURL = (String)defaultSettings.getValue("org.kie.provisioning.openshift.defaultTemplate");
            this.view.setTemplateURL(templateURL);
            this.view.setImageStreamsURL((String)defaultSettings.getValue("org.kie.provisioning.openshift.defaultImageStreams"));
            this.view.setSecretsFileURL((String)defaultSettings.getValue("org.kie.provisioning.openshift.defaultSecrets"));
            if (templateURL != null) {
                this.loadTemplate(templateURL);
            }
        };
    }

    private void loadTemplate(String templateURL) {
        this.templateLoaded = false;
        this.clearParams();
        ((OpenShiftClientService)this.openShiftClientService.call(this.getServerTemplateConfigSuccessCallback(), this.getServerTemplateConfigErrorCallback())).getTemplateModel(templateURL);
    }

    private RemoteCallback<TemplateDescriptorModel> getServerTemplateConfigSuccessCallback() {
        return templateModel -> {
            this.templateLoaded = true;
            this.view.setTemplateURLStatus(FormStatus.VALID);
            this.setup(templateModel.getParams());
            this.onContentChange();
        };
    }

    private ErrorCallback<Message> getServerTemplateConfigErrorCallback() {
        return (message, throwable) -> {
            this.templateLoaded = false;
            this.view.setTemplateURLStatus(FormStatus.ERROR);
            this.popupHelper.showErrorPopup(this.translationService.getTranslation("TemplateParamsFormPresenter.GetTemplateFileConfigError") + ": " + throwable.getMessage());
            this.onContentChange();
            return false;
        };
    }

    private void setup(List<TemplateParam> templateParams) {
        this.params = templateParams.stream().filter(param -> !bannedParameters.contains(param.getName())).collect(Collectors.toList());
        this.paramsEditorPresenter.setItems(this.params);
        this.updateRequiredParamsHelpText();
    }

    protected void onRuntimeNameChange() {
        this.openShiftClientValidationService.isValidProjectName(this.getRuntimeName(), new ValidatorCallback(){

            public void onSuccess() {
                TemplateParamsFormPresenter.this.view.setRuntimeNameStatus(FormStatus.VALID);
                TemplateParamsFormPresenter.this.view.clearRuntimeNameHelpText();
                TemplateParamsFormPresenter.this.runtimeNameValid = true;
                TemplateParamsFormPresenter.this.onContentChange();
            }

            public void onFailure() {
                TemplateParamsFormPresenter.this.view.setRuntimeNameStatus(FormStatus.ERROR);
                TemplateParamsFormPresenter.this.view.setRuntimeNameHelpText(TemplateParamsFormPresenter.this.translationService.getTranslation("TemplateParamsFormPresenter.InvalidProjectNameError"));
                TemplateParamsFormPresenter.this.runtimeNameValid = false;
                TemplateParamsFormPresenter.this.onContentChange();
            }
        });
    }

    protected void onTemplateURLChange() {
        if (this.getTemplateURL().isEmpty()) {
            this.templateLoaded = false;
            this.view.setTemplateURLStatus(FormStatus.ERROR);
            this.clearParams();
            this.onContentChange();
        } else {
            this.loadTemplate(this.getTemplateURL());
        }
    }

    protected void onImageStreamsURLChange() {
        if (this.getImageStreamsURL().isEmpty()) {
            this.view.setImageStreamsURLStatus(FormStatus.ERROR);
        } else {
            this.view.setImageStreamsURLStatus(FormStatus.VALID);
        }
        this.onContentChange();
    }

    protected void onSecretsFileURLChange() {
        if (this.getSecretsFileURL().isEmpty()) {
            this.view.setSecretsFileURLStatus(FormStatus.ERROR);
        } else {
            this.view.setSecretsFileURLStatus(FormStatus.VALID);
        }
        this.onContentChange();
    }

    protected void onContainerConfigurationsChange(@Observes ContainerConfigParamsChangeEvent event) {
        this.configuredContainers = event.getContainerConfigs();
    }

    protected void onParamChange() {
        this.updateRequiredParamsHelpText();
        this.onContentChange();
    }

    protected void onContentChange() {
        this.fireChangeHandlers();
    }

    private void clearParams() {
        this.params.clear();
        this.paramsEditorPresenter.clear();
        this.updateRequiredParamsHelpText();
    }

    private String getRuntimeName() {
        return this.view.getRuntimeName();
    }

    private String getTemplateURL() {
        return UIUtil.trimOrGetEmpty((String)this.view.getTemplateURL());
    }

    private String getImageStreamsURL() {
        return UIUtil.trimOrGetEmpty((String)this.view.getImageStreamsURL());
    }

    private String getSecretsFileURL() {
        return UIUtil.trimOrGetEmpty((String)this.view.getSecretsFileURL());
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private boolean isRuntimeValid() {
        return this.runtimeNameValid;
    }

    private boolean isTemplateValid() {
        return this.templateLoaded;
    }

    private boolean isImageStreamsURLValid() {
        return !this.getImageStreamsURL().isEmpty();
    }

    private boolean isSecretsFileURLValid() {
        return !this.getSecretsFileURL().isEmpty();
    }

    private boolean isParamsValid() {
        if (this.params != null) {
            return !this.params.stream().filter(param -> param.isRequired() && this.isEmpty(param.getValue())).findFirst().isPresent();
        }
        return true;
    }

    private void updateRequiredParamsHelpText() {
        this.view.clearRequiredParamsHelpText();
        if (!this.isParamsValid()) {
            this.view.setRequiredParamsHelpText(this.translationService.getTranslation("TemplateParamsFormPresenter.RequiredParamsNotCompletedMessage"));
        }
    }

    private boolean isBanned(String paramName) {
        return bannedParameters.contains(paramName);
    }

    private void addTemplateParam(StringBuilder builder, String paramName, String paramValue) {
        if (builder.length() > 0) {
            builder.append(PARAM_DELIMITER);
        }
        builder.append(paramName);
        builder.append(PARAM_ASSIGNER);
        builder.append(paramValue);
    }

    protected String buildContainerDeploymentParamValue(List<ContainerConfig> containerConfigs) {
        return containerConfigs.stream().map(this::buildContainerParamValue).collect(Collectors.joining(CONTAINER_DELIMITER));
    }

    protected String buildContainerParamValue(ContainerConfig containerConfig) {
        return containerConfig.getName() + PARAM_ASSIGNER + containerConfig.getGroupId() + ":" + containerConfig.getArtifactId() + ":" + containerConfig.getVersion();
    }

    static {
        bannedParameters.add(IMAGE_STREAM_NAMESPACE_TEMPLATE_PARAM);
        bannedParameters.add(APPLICATION_NAME_TEMPLATE_PARAM);
        bannedParameters.add(HORNETQ_QUEUES);
        bannedParameters.add(HORNETQ_TOPICS);
        bannedParameters.add(HORNETQ_CLUSTER_PASSWORD);
    }

    public static interface View
    extends UberElement<TemplateParamsFormPresenter> {
        public void setTemplateURL(String var1);

        public String getTemplateURL();

        public void setImageStreamsURL(String var1);

        public String getImageStreamsURL();

        public void setSecretsFileURL(String var1);

        public String getSecretsFileURL();

        public void setRuntimeName(String var1);

        public String getRuntimeName();

        public void setRuntimeNameStatus(FormStatus var1);

        public void setTemplateURLStatus(FormStatus var1);

        public void setImageStreamsURLStatus(FormStatus var1);

        public void setSecretsFileURLStatus(FormStatus var1);

        public void setRequiredParamsHelpText(String var1);

        public void clearRequiredParamsHelpText();

        public void setRuntimeNameHelpText(String var1);

        public void clearRuntimeNameHelpText();

        public void clear();

        public String getWizardTitle();

        public void setParamsEditorPresenter(IsElement var1);
    }
}

