/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.pipeline.template.table;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.HasData;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.ala.ui.openshift.client.pipeline.template.table.TemplateParamsTablePresenter;
import org.guvnor.ala.ui.openshift.model.TemplateParam;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;

@Templated
public class TemplateParamsTableView
implements TemplateParamsTablePresenter.View,
IsElement {
    @DataField(value="params-table")
    private SimpleTable<TemplateParam> dataGrid = new SimpleTable();
    @Inject
    private TranslationService translationService;
    private TemplateParamsTablePresenter presenter;

    @PostConstruct
    private void init() {
        this.dataGrid.setColumnPickerButtonVisible(false);
        this.dataGrid.setToolBarVisible(false);
        this.dataGrid.setEmptyTableCaption(this.translationService.getTranslation("TemplateParamsTableView.ParamsEmptyTableCaption"));
        this.addParamNameColumn();
        this.addParamRequiredColumn();
        this.addParamValueColumn();
    }

    public void init(TemplateParamsTablePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public HasData<TemplateParam> getDisplay() {
        return this.dataGrid;
    }

    @Override
    public void redraw() {
        this.dataGrid.redraw();
    }

    private void addParamNameColumn() {
        Column<TemplateParam, String> column = new Column<TemplateParam, String>((Cell)new TextCell()){

            public String getValue(TemplateParam templateParam) {
                return templateParam.isRequired() ? templateParam.getName() : templateParam.getName();
            }
        };
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("TemplateParamsTableView.ParamNameColumn"));
        this.dataGrid.setColumnWidth((Column)column, 40.0, Style.Unit.PCT);
    }

    private void addParamRequiredColumn() {
        Column<TemplateParam, String> column = new Column<TemplateParam, String>((Cell)new TextCell()){

            public String getValue(TemplateParam templateParam) {
                return templateParam.isRequired() ? "*" : "";
            }
        };
        this.dataGrid.addColumn((Column)column, " ");
        this.dataGrid.setColumnWidth((Column)column, 30.0, Style.Unit.PX);
    }

    private void addParamValueColumn() {
        Column<TemplateParam, String> column = new Column<TemplateParam, String>((Cell)new EditTextCell()){

            public String getValue(TemplateParam templateParam) {
                if (templateParam.getValue() != null) {
                    return templateParam.getValue();
                }
                return "";
            }
        };
        column.setFieldUpdater((FieldUpdater)new ParamValueFieldUpdater((EditTextCell)column.getCell()));
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("TemplateParamsTableView.ParamValueColumn"));
        this.dataGrid.setColumnWidth((Column)column, 55.0, Style.Unit.PCT);
    }

    private class ParamValueFieldUpdater
    implements FieldUpdater<TemplateParam, String> {
        private EditTextCell cell;

        ParamValueFieldUpdater(EditTextCell cell) {
            this.cell = cell;
        }

        public void update(int index, TemplateParam templateParam, String value) {
            String oldValue = templateParam.getValue();
            templateParam.setValue(value);
            TemplateParamsTableView.this.presenter.onParamChange(templateParam.getName(), value, oldValue);
        }
    }
}

