/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.handler;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.handler.ClientProviderHandler;
import org.guvnor.ala.ui.client.handler.FormResolver;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.openshift.client.handler.OpenShiftFormResolver;
import org.guvnor.ala.ui.openshift.client.resources.images.GuvnorAlaOpenShiftUIImageResources;

@ApplicationScoped
public class OpenShiftClientProviderHandler
implements ClientProviderHandler {
    private static final String PROVIDER_TYPE_NAME = "openshift";
    private OpenShiftFormResolver formResolver;

    @Inject
    public OpenShiftClientProviderHandler(OpenShiftFormResolver formResolver) {
        this.formResolver = formResolver;
    }

    public int getPriority() {
        return 1;
    }

    public boolean acceptProviderType(ProviderTypeKey providerTypeKey) {
        return providerTypeKey != null && PROVIDER_TYPE_NAME.equals(providerTypeKey.getId());
    }

    public FormResolver getFormResolver() {
        return this.formResolver;
    }

    public String getProviderTypeImageURL() {
        return GuvnorAlaOpenShiftUIImageResources.INSTANCE.providerIcon().getSafeUri().asString();
    }
}

