/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.vfs;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTrace;
import org.guvnor.ala.registry.inmemory.InMemoryPipelineExecutorRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryPipelineExecutorRegistryTest;
import org.guvnor.ala.registry.vfs.VFSPipelineExecutorRegistry;
import org.guvnor.ala.registry.vfs.VFSRegistryHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class VFSPipelineExecutorRegistryTest
extends InMemoryPipelineExecutorRegistryTest {
    private static final String PIPELINE_EXECUTION_ID_MD5 = "PIPELINE_EXECUTION_ID_MD5";
    @Mock
    private VFSRegistryHelper registryHelper;
    @Mock
    private Path registryRoot;
    private List<Object> traces;
    @Mock
    private Path traceTargetPath;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        super.setUp();
        Mockito.when((Object)this.registryHelper.ensureDirectory("executor-registry")).thenReturn((Object)this.registryRoot);
        this.pipelineExecutorRegistry = (InMemoryPipelineExecutorRegistry)Mockito.spy((Object)new VFSPipelineExecutorRegistry(this.registryHelper));
        ((VFSPipelineExecutorRegistry)this.pipelineExecutorRegistry).init();
    }

    @Test
    public void testInit() throws Exception {
        this.traces = new ArrayList<Object>();
        for (int i = 0; i < 10; ++i) {
            PipelineExecutorTrace pipelineExecutorTrace = (PipelineExecutorTrace)Mockito.mock(PipelineExecutorTrace.class);
            Mockito.when((Object)pipelineExecutorTrace.getTaskId()).thenReturn((Object)("PIPELINE_EXECUTION_ID" + Integer.toString(i)));
            this.traces.add(pipelineExecutorTrace);
        }
        Mockito.when((Object)this.registryHelper.readEntries(this.registryRoot, (DirectoryStream.Filter)VFSRegistryHelper.BySuffixFilter.newFilter((String)"-trace.entry"))).thenReturn(this.traces);
        ((VFSPipelineExecutorRegistry)this.pipelineExecutorRegistry).init();
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)2))).ensureDirectory("executor-registry");
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)2))).readEntries(this.registryRoot, (DirectoryStream.Filter)VFSRegistryHelper.BySuffixFilter.newFilter((String)"-trace.entry"));
        for (Object object : this.traces) {
            PipelineExecutorTrace result = this.pipelineExecutorRegistry.getExecutorTrace(((PipelineExecutorTrace)object).getTaskId());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)object, (Object)result);
        }
    }

    @Test
    public void testRegister() {
        this.prepareTargetPath();
        this.pipelineExecutorRegistry.register(this.trace);
        try {
            ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1))).storeEntry(this.traceTargetPath, (Object)this.trace);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        PipelineExecutorTrace result = this.pipelineExecutorRegistry.getExecutorTrace("PIPELINE_EXECUTION_ID");
        Assert.assertEquals((Object)this.trace, (Object)result);
    }

    @Test
    public void testRegisterWhenMarshallingErrors() throws Exception {
        this.prepareTargetPath();
        this.expectedException.expectMessage("Unexpected error was produced during trace marshalling/storing, trace: " + this.trace);
        ((VFSRegistryHelper)Mockito.doThrow((Throwable[])new Throwable[]{new Exception("no matter the message here")}).when((Object)this.registryHelper)).storeEntry(this.traceTargetPath, (Object)this.trace);
        this.pipelineExecutorRegistry.register(this.trace);
    }

    @Test
    public void testDeregister() {
        this.prepareTargetPath();
        this.pipelineExecutorRegistry.register(this.trace);
        PipelineExecutorTrace result = this.pipelineExecutorRegistry.getExecutorTrace("PIPELINE_EXECUTION_ID");
        Assert.assertEquals((Object)this.trace, (Object)result);
        this.pipelineExecutorRegistry.deregister("PIPELINE_EXECUTION_ID");
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1))).deleteBatch(this.traceTargetPath);
        result = this.pipelineExecutorRegistry.getExecutorTrace("PIPELINE_EXECUTION_ID");
        Assert.assertNull((Object)result);
    }

    private void prepareTargetPath() {
        Mockito.when((Object)this.registryHelper.md5Hex("PIPELINE_EXECUTION_ID")).thenReturn((Object)PIPELINE_EXECUTION_ID_MD5);
        String expectedPath = "PIPELINE_EXECUTION_ID_MD5-trace.entry";
        Mockito.when((Object)this.registryRoot.resolve(expectedPath)).thenReturn((Object)this.traceTargetPath);
    }
}

