/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.backend.impl;

import java.util.List;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.PipelineService;
import org.guvnor.ala.services.api.itemlist.PipelineConfigsList;
import org.guvnor.ala.services.backend.impl.PipelineServiceBackendImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PipelineServiceBackendImplTest {
    private PipelineService pipelineService;
    private PipelineServiceBackendImpl pipelineServiceBackend;
    private static final int ELEMENTS_COUNT = 10;
    private static final Integer PAGE = 1234;
    private static final Integer PAGE_SIZE = 10;
    private static final Boolean SORT_ORDER = Boolean.FALSE;
    private static final String SORT = "SORT";
    private static final String PROVIDER_TYPE_NAME = "PROVIDER_TYPE_NAME";
    private static final String PROVIDER_TYPE_VERSION = "PROVIDER_TYPE_VERSION";
    private static final String PIPELINE_NAME = "PIPELINE_NAME";
    private static final String PIPELINE_EXECUTION_ID = "PIPELINE_EXECUTION_ID";
    private ProviderType providerType;

    @Before
    public void setUp() {
        this.providerType = (ProviderType)Mockito.mock(ProviderType.class);
        Mockito.when((Object)this.providerType.getProviderTypeName()).thenReturn((Object)PROVIDER_TYPE_NAME);
        Mockito.when((Object)this.providerType.getVersion()).thenReturn((Object)PROVIDER_TYPE_VERSION);
        this.pipelineService = (PipelineService)Mockito.mock(PipelineService.class);
        this.pipelineServiceBackend = new PipelineServiceBackendImpl(this.pipelineService);
    }

    @Test
    public void testGetPipelineConfigs() {
        List values = AlaSPITestCommons.mockList(PipelineConfig.class, (int)10);
        PipelineConfigsList list = new PipelineConfigsList(values);
        Mockito.when((Object)this.pipelineService.getPipelineConfigs(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue())).thenReturn((Object)list);
        List result = this.pipelineServiceBackend.getPipelineConfigs(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        ((PipelineService)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).getPipelineConfigs(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        Assert.assertEquals((Object)result, (Object)values);
    }

    @Test
    public void testGetPipelineConfigsForProviderType() {
        List values = AlaSPITestCommons.mockList(PipelineConfig.class, (int)10);
        PipelineConfigsList list = new PipelineConfigsList(values);
        Mockito.when((Object)this.pipelineService.getPipelineConfigs(PROVIDER_TYPE_NAME, PROVIDER_TYPE_VERSION, PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue())).thenReturn((Object)list);
        List result = this.pipelineServiceBackend.getPipelineConfigs(this.providerType, PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        ((PipelineService)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).getPipelineConfigs(PROVIDER_TYPE_NAME, PROVIDER_TYPE_VERSION, PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        Assert.assertEquals((Object)result, (Object)values);
    }

    @Test
    public void testGetPipelineNames() {
        List values = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.pipelineService.getPipelineNames(PROVIDER_TYPE_NAME, PROVIDER_TYPE_VERSION, PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue())).thenReturn((Object)values);
        List result = this.pipelineServiceBackend.getPipelineNames(this.providerType, PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        ((PipelineService)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).getPipelineNames(PROVIDER_TYPE_NAME, PROVIDER_TYPE_VERSION, PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        Assert.assertEquals((Object)values, (Object)result);
    }

    @Test
    public void testNewPipelineForProvider() {
        PipelineConfig pipelineConfig = (PipelineConfig)Mockito.mock(PipelineConfig.class);
        Mockito.when((Object)this.pipelineService.newPipeline(pipelineConfig, this.providerType)).thenReturn((Object)PIPELINE_NAME);
        String result = this.pipelineServiceBackend.newPipeline(pipelineConfig, this.providerType);
        ((PipelineService)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).newPipeline(pipelineConfig, this.providerType);
        Assert.assertEquals((Object)PIPELINE_NAME, (Object)result);
    }

    @Test
    public void testNewPipeline() {
        PipelineConfig pipelineConfig = (PipelineConfig)Mockito.mock(PipelineConfig.class);
        Mockito.when((Object)this.pipelineService.newPipeline(pipelineConfig)).thenReturn((Object)PIPELINE_NAME);
        String result = this.pipelineServiceBackend.newPipeline(pipelineConfig);
        ((PipelineService)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).newPipeline(pipelineConfig);
        Assert.assertEquals((Object)PIPELINE_NAME, (Object)result);
    }

    @Test
    public void testRunPipelineSync() {
        this.testRunPipeline(false);
    }

    @Test
    public void testRunPipelineAsync() {
        this.testRunPipeline(true);
    }

    private void testRunPipeline(boolean async) {
        Input input = (Input)Mockito.mock(Input.class);
        Mockito.when((Object)this.pipelineService.runPipeline(PIPELINE_NAME, input, async)).thenReturn((Object)PIPELINE_EXECUTION_ID);
        String result = this.pipelineServiceBackend.runPipeline(PIPELINE_NAME, input, async);
        ((PipelineService)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).runPipeline(PIPELINE_NAME, input, async);
        Assert.assertEquals((Object)PIPELINE_EXECUTION_ID, (Object)result);
    }

    @Test
    public void testStopPipelineExecution() {
        this.pipelineServiceBackend.stopPipelineExecution(PIPELINE_EXECUTION_ID);
        ((PipelineService)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).stopPipelineExecution(PIPELINE_EXECUTION_ID);
    }

    @Test
    public void testDeletePipelineExecution() {
        this.pipelineServiceBackend.deletePipelineExecution(PIPELINE_EXECUTION_ID);
        ((PipelineService)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).deletePipelineExecution(PIPELINE_EXECUTION_ID);
    }
}

