/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.backend.impl;

import java.util.List;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.RuntimeProvisioningService;
import org.guvnor.ala.services.api.RuntimeQuery;
import org.guvnor.ala.services.api.RuntimeQueryResultItem;
import org.guvnor.ala.services.api.itemlist.ProviderList;
import org.guvnor.ala.services.api.itemlist.ProviderTypeList;
import org.guvnor.ala.services.api.itemlist.RuntimeList;
import org.guvnor.ala.services.api.itemlist.RuntimeQueryResultItemList;
import org.guvnor.ala.services.backend.impl.RuntimeProvisioningServiceBackendImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RuntimeProvisioningServiceBackendImplTest {
    private static final int ELEMENTS_COUNT = 10;
    private static final Integer PAGE = 1234;
    private static final Integer PAGE_SIZE = 10;
    private static final Boolean SORT_ORDER = Boolean.FALSE;
    private static final String SORT = "SORT";
    private static final String PROVIDER_NAME = "PROVIDER_NAME";
    private static final String RUNTIME_ID = "RUNTIME_ID";
    private RuntimeProvisioningService runtimeProvisioningService;
    private RuntimeProvisioningServiceBackendImpl runtimeProvisioningServiceBackend;

    @Before
    public void setUp() {
        this.runtimeProvisioningService = (RuntimeProvisioningService)Mockito.mock(RuntimeProvisioningService.class);
        this.runtimeProvisioningServiceBackend = new RuntimeProvisioningServiceBackendImpl(this.runtimeProvisioningService);
    }

    @Test
    public void testGetProviderTypes() {
        List values = AlaSPITestCommons.mockList(ProviderType.class, (int)10);
        ProviderTypeList list = new ProviderTypeList(values);
        Mockito.when((Object)this.runtimeProvisioningService.getProviderTypes(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue())).thenReturn((Object)list);
        List result = this.runtimeProvisioningServiceBackend.getProviderTypes(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).getProviderTypes(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        Assert.assertEquals((Object)values, (Object)result);
    }

    @Test
    public void testGetProviders() {
        List values = AlaSPITestCommons.mockList(Provider.class, (int)10);
        ProviderList list = new ProviderList(values);
        Mockito.when((Object)this.runtimeProvisioningService.getProviders(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue())).thenReturn((Object)list);
        List result = this.runtimeProvisioningServiceBackend.getProviders(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).getProviders(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        Assert.assertEquals((Object)values, (Object)result);
    }

    @Test
    public void testGetRuntimes() {
        List values = AlaSPITestCommons.mockList(Runtime.class, (int)10);
        RuntimeList list = new RuntimeList(values);
        Mockito.when((Object)this.runtimeProvisioningService.getRuntimes(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue())).thenReturn((Object)list);
        List result = this.runtimeProvisioningServiceBackend.getRuntimes(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).getRuntimes(PAGE, PAGE_SIZE, SORT, SORT_ORDER.booleanValue());
        Assert.assertEquals((Object)values, (Object)result);
    }

    @Test
    public void testRegisterProvider() {
        ProviderConfig providerConfig = (ProviderConfig)Mockito.mock(ProviderConfig.class);
        this.runtimeProvisioningServiceBackend.registerProvider(providerConfig);
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).registerProvider(providerConfig);
    }

    @Test
    public void unregisterProvider() {
        this.runtimeProvisioningServiceBackend.unregisterProvider(PROVIDER_NAME);
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).deregisterProvider(PROVIDER_NAME);
    }

    @Test
    public void testNewRuntime() {
        RuntimeConfig runtimeConfig = (RuntimeConfig)Mockito.mock(RuntimeConfig.class);
        Mockito.when((Object)this.runtimeProvisioningService.newRuntime(runtimeConfig)).thenReturn((Object)RUNTIME_ID);
        String result = this.runtimeProvisioningServiceBackend.newRuntime(runtimeConfig);
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).newRuntime(runtimeConfig);
        Assert.assertEquals((Object)RUNTIME_ID, (Object)result);
    }

    @Test
    public void testDestroyRuntimeNotForced() {
        this.runtimeProvisioningServiceBackend.destroyRuntime(RUNTIME_ID, false);
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).destroyRuntime(RUNTIME_ID, false);
    }

    @Test
    public void testDestroyRuntimeForced() {
        this.runtimeProvisioningServiceBackend.destroyRuntime(RUNTIME_ID, true);
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).destroyRuntime(RUNTIME_ID, true);
    }

    @Test
    public void testStartRuntime() {
        this.runtimeProvisioningServiceBackend.startRuntime(RUNTIME_ID);
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService)).startRuntime(RUNTIME_ID);
    }

    @Test
    public void testStopRuntime() {
        this.runtimeProvisioningServiceBackend.stopRuntime(RUNTIME_ID);
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService)).stopRuntime(RUNTIME_ID);
    }

    @Test
    public void testRestartRuntime() {
        this.runtimeProvisioningServiceBackend.restartRuntime(RUNTIME_ID);
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService)).restartRuntime(RUNTIME_ID);
    }

    @Test
    public void testExecuteQuery() {
        RuntimeQuery query = (RuntimeQuery)Mockito.mock(RuntimeQuery.class);
        List values = AlaSPITestCommons.mockList(RuntimeQueryResultItem.class, (int)10);
        RuntimeQueryResultItemList list = new RuntimeQueryResultItemList(values);
        Mockito.when((Object)this.runtimeProvisioningService.executeQuery(query)).thenReturn((Object)list);
        List result = this.runtimeProvisioningServiceBackend.executeQuery(query);
        ((RuntimeProvisioningService)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).executeQuery(query);
        Assert.assertEquals((Object)values, (Object)result);
    }
}

