/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.events.AfterPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.AfterStageExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforePipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.BeforeStageExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorPipelineExecutionEvent;
import org.guvnor.ala.pipeline.events.OnErrorStageExecutionEvent;
import org.guvnor.ala.ui.backend.service.PipelineExecutionListener;
import org.guvnor.ala.ui.events.PipelineStatusChangeEvent;
import org.guvnor.ala.ui.events.StageStatusChangeEvent;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class PipelineExecutionListenerTest {
    private static final String EXECUTION_ID = "EXECUTION_ID";
    private static final String STAGE_NAME = "STAGE_NAME";
    @Mock
    private EventSourceMock<PipelineStatusChangeEvent> pipelineStatusChangeEvent;
    @Mock
    private EventSourceMock<StageStatusChangeEvent> stageStatusChangeEvent;
    private PipelineExecutionListener listener;
    private PipelineExecutionTraceKey traceKey;
    private Pipeline pipeline;
    private Stage stage;
    private Throwable throwable;

    @Before
    public void setUp() {
        this.traceKey = new PipelineExecutionTraceKey(EXECUTION_ID);
        this.pipeline = (Pipeline)Mockito.mock(Pipeline.class);
        this.stage = (Stage)Mockito.mock(Stage.class);
        Mockito.when((Object)this.stage.getName()).thenReturn((Object)STAGE_NAME);
        this.throwable = (Throwable)Mockito.mock(Throwable.class);
        this.listener = new PipelineExecutionListener(this.pipelineStatusChangeEvent, this.stageStatusChangeEvent);
    }

    @Test
    public void testBeforePipelineExecution() {
        this.listener.beforePipelineExecution(new BeforePipelineExecutionEvent(EXECUTION_ID, this.pipeline));
        ((EventSourceMock)Mockito.verify(this.pipelineStatusChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new PipelineStatusChangeEvent(this.traceKey, PipelineStatus.RUNNING));
    }

    @Test
    public void testAfterPipelineExecution() {
        this.listener.afterPipelineExecution(new AfterPipelineExecutionEvent(EXECUTION_ID, this.pipeline));
        ((EventSourceMock)Mockito.verify(this.pipelineStatusChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new PipelineStatusChangeEvent(this.traceKey, PipelineStatus.FINISHED));
    }

    @Test
    public void testBeforeStageExecution() {
        this.listener.beforeStageExecution(new BeforeStageExecutionEvent(EXECUTION_ID, this.pipeline, this.stage));
        ((EventSourceMock)Mockito.verify(this.stageStatusChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new StageStatusChangeEvent(this.traceKey, STAGE_NAME, PipelineStatus.RUNNING));
    }

    @Test
    public void testOnStageError() {
        this.listener.onStageError(new OnErrorStageExecutionEvent(EXECUTION_ID, this.pipeline, this.stage, this.throwable));
        ((EventSourceMock)Mockito.verify(this.stageStatusChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new StageStatusChangeEvent(this.traceKey, STAGE_NAME, PipelineStatus.ERROR));
    }

    @Test
    public void testAfterStageExecution() {
        this.listener.afterStageExecution(new AfterStageExecutionEvent(EXECUTION_ID, this.pipeline, this.stage));
        ((EventSourceMock)Mockito.verify(this.stageStatusChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new StageStatusChangeEvent(this.traceKey, STAGE_NAME, PipelineStatus.FINISHED));
    }

    @Test
    public void testOnPipelineError() {
        this.listener.onPipelineError(new OnErrorPipelineExecutionEvent(EXECUTION_ID, this.pipeline, this.stage, this.throwable));
        ((EventSourceMock)Mockito.verify(this.pipelineStatusChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new PipelineStatusChangeEvent(this.traceKey, PipelineStatus.ERROR));
    }
}

