/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.services.api.backend.RuntimeProvisioningServiceBackend;
import org.guvnor.ala.ui.backend.service.ProviderServiceImpl;
import org.guvnor.ala.ui.backend.service.converter.ProviderConfigConverter;
import org.guvnor.ala.ui.backend.service.converter.ProviderConverter;
import org.guvnor.ala.ui.backend.service.converter.ProviderConverterFactory;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ProviderServiceImplTest {
    private static final int PROVIDER_COUNT = 5;
    @Mock
    private RuntimeProvisioningServiceBackend runtimeProvisioningService;
    @Mock
    private ProviderConverterFactory providerConverterFactory;
    @Mock
    private ProviderConverter providerConverter;
    @Mock
    private ProviderConfigConverter providerConfigConverter;
    private ProviderServiceImpl service;
    private List<Provider> providersSpi;
    private org.guvnor.ala.runtime.providers.ProviderType providerTypeSpi;
    private List<org.guvnor.ala.ui.model.Provider> providers;
    private List<ProviderKey> providerKeys;
    private ProviderTypeKey providerTypeKey;
    private ProviderType providerType;
    private ProviderConfiguration providerConfiguration;
    private ProviderConfig providerConfig;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.providerTypeSpi = AlaSPITestCommons.mockProviderTypeSPI((String)"0");
        this.providersSpi = AlaSPITestCommons.mockProviderListSPI((org.guvnor.ala.runtime.providers.ProviderType)this.providerTypeSpi, (int)5);
        Mockito.when((Object)this.runtimeProvisioningService.getProviders(Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()), Matchers.anyString(), Matchers.anyBoolean())).thenReturn(this.providersSpi);
        this.providerTypeKey = new ProviderTypeKey(this.providerTypeSpi.getProviderTypeName(), this.providerTypeSpi.getVersion());
        this.providerType = new ProviderType(this.providerTypeKey, null);
        Mockito.when((Object)this.providerConverterFactory.getProviderConverter()).thenReturn((Object)this.providerConverter);
        Mockito.when((Object)this.providerConverterFactory.getProviderConfigConverter(this.providerTypeKey)).thenReturn((Object)this.providerConfigConverter);
        this.providers = new ArrayList<org.guvnor.ala.ui.model.Provider>();
        this.providerKeys = new ArrayList<ProviderKey>();
        for (int i = 0; i < 5; ++i) {
            org.guvnor.ala.ui.model.Provider provider = (org.guvnor.ala.ui.model.Provider)Mockito.mock(org.guvnor.ala.ui.model.Provider.class);
            ProviderTypeKey providerTypeKey = new ProviderTypeKey(this.providersSpi.get(i).getProviderType().getProviderTypeName(), this.providersSpi.get(i).getProviderType().getVersion());
            ProviderKey providerKey = new ProviderKey(providerTypeKey, this.providersSpi.get(i).getId());
            Mockito.when((Object)provider.getKey()).thenReturn((Object)providerKey);
            this.providers.add(provider);
            this.providerKeys.add(providerKey);
            Mockito.when((Object)this.providerConverter.toModel((Object)this.providersSpi.get(i))).thenReturn((Object)provider);
        }
        this.service = new ProviderServiceImpl(this.runtimeProvisioningService, this.providerConverterFactory);
    }

    @Test
    public void testGetProviders() {
        Collection result = this.service.getProviders(this.providerType);
        Assert.assertEquals(this.providers, (Object)result);
    }

    @Test
    public void testGetProvidersKey() {
        Collection result = this.service.getProvidersKey(this.providerType);
        Assert.assertEquals(this.providerKeys, (Object)result);
    }

    @Test
    public void testCreateProvider() {
        this.prepareConfigurationForCreate();
        Mockito.when((Object)this.providerConfiguration.getId()).thenReturn((Object)"PROVIDER_ID");
        this.service.createProvider(this.providerType, this.providerConfiguration);
        ((RuntimeProvisioningServiceBackend)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).registerProvider(this.providerConfig);
    }

    @Test
    public void testCreateProviderExisting() {
        this.prepareConfigurationForCreate();
        String existingId = ((ProviderKey)this.providers.get(1).getKey()).getId();
        Mockito.when((Object)this.providerConfiguration.getId()).thenReturn((Object)existingId);
        this.expectedException.expectMessage("A provider with the given name already exists: " + existingId);
        this.service.createProvider(this.providerType, this.providerConfiguration);
        ((RuntimeProvisioningServiceBackend)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.never())).registerProvider((ProviderConfig)Matchers.any(ProviderConfig.class));
    }

    @Test
    public void testDeleteProvider() {
        ProviderKey providerKey = (ProviderKey)Mockito.mock(ProviderKey.class);
        Mockito.when((Object)providerKey.getId()).thenReturn((Object)"PROVIDER_ID");
        this.service.deleteProvider(providerKey);
        ((RuntimeProvisioningServiceBackend)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).unregisterProvider("PROVIDER_ID");
    }

    @Test
    public void testGetProviderExisting() {
        Provider providerSpi = this.providersSpi.get(2);
        ProviderTypeKey providerTypeKey = new ProviderTypeKey(providerSpi.getProviderType().getProviderTypeName(), providerSpi.getProviderType().getVersion());
        ProviderKey providerKey = new ProviderKey(providerTypeKey, providerSpi.getId());
        org.guvnor.ala.ui.model.Provider provider = this.service.getProvider(providerKey);
        Assert.assertNotNull((Object)provider);
        Assert.assertEquals((Object)this.providers.get(2).getKey(), (Object)provider.getKey());
    }

    @Test
    public void testGetProviderNotExisting() {
        ProviderTypeKey providerTypeKey = new ProviderTypeKey("not exist", "not exist");
        ProviderKey providerKey = new ProviderKey(providerTypeKey, "not exist");
        org.guvnor.ala.ui.model.Provider provider = this.service.getProvider(providerKey);
        Assert.assertNull((Object)provider);
    }

    private void prepareConfigurationForCreate() {
        this.providerConfiguration = (ProviderConfiguration)Mockito.mock(ProviderConfiguration.class);
        Map values = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)values.size()).thenReturn((Object)5);
        Mockito.when((Object)this.providerConfiguration.getValues()).thenReturn((Object)values);
        this.providerConfig = (ProviderConfig)Mockito.mock(ProviderConfig.class);
        Mockito.when((Object)this.providerConfigConverter.toDomain((Object)this.providerConfiguration)).thenReturn((Object)this.providerConfig);
    }
}

