/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.RuntimeQuery;
import org.guvnor.ala.services.api.RuntimeQueryBuilder;
import org.guvnor.ala.services.api.RuntimeQueryResultItem;
import org.guvnor.ala.services.api.backend.PipelineServiceBackend;
import org.guvnor.ala.services.api.backend.RuntimeProvisioningServiceBackend;
import org.guvnor.ala.ui.backend.service.PipelineInputBuilder;
import org.guvnor.ala.ui.backend.service.PipelineInputBuilderTest;
import org.guvnor.ala.ui.backend.service.RuntimeListItemBuilder;
import org.guvnor.ala.ui.backend.service.RuntimeListItemBuilderTest;
import org.guvnor.ala.ui.backend.service.RuntimeServiceImpl;
import org.guvnor.ala.ui.events.PipelineExecutionChange;
import org.guvnor.ala.ui.events.PipelineExecutionChangeEvent;
import org.guvnor.ala.ui.events.RuntimeChange;
import org.guvnor.ala.ui.events.RuntimeChangeEvent;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.service.ProviderService;
import org.guvnor.ala.ui.service.RuntimeService;
import org.guvnor.common.services.project.model.Module;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class RuntimeServiceImplTest {
    private static final int QUERY_ITEMS_SIZE = 5;
    private static final String RUNTIME_ID = "RUNTIME_ID";
    private static final String MODULE_NAME = "MODULE_NAME";
    private static final String PIPELINE = "PIPELINE";
    private static final String PIPELINE_EXECUTION_ID = "PIPELINE_EXECUTION_ID";
    private static final PipelineKey PIPELINE_KEY = new PipelineKey("PIPELINE");
    private static final int PARAMS_COUNT = 5;
    @Mock
    private Module module;
    @Mock
    private RuntimeProvisioningServiceBackend runtimeProvisioningService;
    @Mock
    private PipelineServiceBackend pipelineService;
    @Mock
    private ProviderService providerService;
    private RuntimeService service;
    @Mock
    private EventSourceMock<RuntimeChangeEvent> runtimeChangeEvent;
    @Mock
    private EventSourceMock<PipelineExecutionChangeEvent> pipelineExecutionChangeEvent;
    private List<RuntimeQueryResultItem> queryItems;
    private List<String> pipelineNames;
    private List<PipelineKey> pipelineKeys;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        Mockito.when((Object)this.module.getModuleName()).thenReturn((Object)MODULE_NAME);
        this.queryItems = this.mockRuntimeQueryResultItemList(5);
        this.pipelineNames = this.mockPipelineNames(5);
        this.pipelineKeys = this.mockPipelineKeys(this.pipelineNames);
        this.service = new RuntimeServiceImpl(this.runtimeProvisioningService, this.pipelineService, this.providerService, this.runtimeChangeEvent, this.pipelineExecutionChangeEvent);
    }

    @Test
    public void testGetRuntimeItems() {
        ProviderTypeKey providerTypeKey = new ProviderTypeKey("PROVIDER_NAME", "PROVIDER_VERSION");
        ProviderKey providerKey = new ProviderKey(providerTypeKey, "PROVIDER_ID");
        Mockito.when((Object)this.runtimeProvisioningService.executeQuery((RuntimeQuery)Matchers.any(RuntimeQuery.class))).thenReturn(this.queryItems);
        Collection result = this.service.getRuntimeItems(providerKey);
        Collection<RuntimeListItem> expectedResult = this.buildExpectedResult(this.queryItems);
        Assert.assertEquals(expectedResult, (Object)result);
    }

    @Test
    public void getRuntimeItemByPipelineExecutionKeyExisting() {
        PipelineExecutionTraceKey traceKey = new PipelineExecutionTraceKey(PIPELINE_EXECUTION_ID);
        List<RuntimeQueryResultItem> singleResult = this.mockRuntimeQueryResultItemList(1);
        Mockito.when((Object)this.runtimeProvisioningService.executeQuery((RuntimeQuery)Matchers.any(RuntimeQuery.class))).thenReturn(singleResult);
        RuntimeListItem expectedItem = this.buildExpectedResult(singleResult).iterator().next();
        RuntimeListItem result = this.service.getRuntimeItem(traceKey);
        Assert.assertEquals((Object)expectedItem, (Object)result);
    }

    @Test
    public void getRuntimeItemByPipelineExecutionKeyNotExisting() {
        PipelineExecutionTraceKey traceKey = new PipelineExecutionTraceKey(PIPELINE_EXECUTION_ID);
        ArrayList singleResult = new ArrayList();
        Mockito.when((Object)this.runtimeProvisioningService.executeQuery((RuntimeQuery)Matchers.any(RuntimeQuery.class))).thenReturn(singleResult);
        RuntimeListItem result = this.service.getRuntimeItem(traceKey);
        Assert.assertNull((Object)result);
    }

    @Test
    public void getRuntimeItemByRuntimeKeyExisting() {
        ProviderKey providerKey = (ProviderKey)Mockito.mock(ProviderKey.class);
        RuntimeKey runtimeKey = new RuntimeKey(providerKey, RUNTIME_ID);
        List<RuntimeQueryResultItem> singleResult = this.mockRuntimeQueryResultItemList(1);
        Mockito.when((Object)this.runtimeProvisioningService.executeQuery((RuntimeQuery)Matchers.any(RuntimeQuery.class))).thenReturn(singleResult);
        RuntimeListItem expectedItem = this.buildExpectedResult(singleResult).iterator().next();
        RuntimeListItem result = this.service.getRuntimeItem(runtimeKey);
        Assert.assertEquals((Object)expectedItem, (Object)result);
    }

    @Test
    public void getRuntimeItemByRuntimeKeyNotExisting() {
        ProviderKey providerKey = (ProviderKey)Mockito.mock(ProviderKey.class);
        RuntimeKey runtimeKey = new RuntimeKey(providerKey, RUNTIME_ID);
        ArrayList singleResult = new ArrayList();
        Mockito.when((Object)this.runtimeProvisioningService.executeQuery((RuntimeQuery)Matchers.any(RuntimeQuery.class))).thenReturn(singleResult);
        RuntimeListItem result = this.service.getRuntimeItem(runtimeKey);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetPipelines() {
        ProviderTypeKey providerTypeKey = new ProviderTypeKey("PROVIDER_NAME", "PROVIDER_VERSION");
        Mockito.when((Object)this.pipelineService.getPipelineNames((ProviderType)Matchers.any(ProviderType.class), Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()), Mockito.anyString(), Mockito.anyBoolean())).thenReturn(this.pipelineNames);
        Collection result = this.service.getPipelines(providerTypeKey);
        Assert.assertEquals(this.pipelineKeys, (Object)result);
    }

    @Test
    public void testCreateRuntimeSuccessful() {
        Provider provider = (Provider)Mockito.mock(Provider.class);
        ProviderTypeKey providerTypeKey = new ProviderTypeKey("PROVIDER_NAME", "PROVIDER_VERSION");
        ProviderKey providerKey = new ProviderKey(providerTypeKey, "PROVIDER_ID");
        Map<String, String> params = PipelineInputBuilderTest.mockParams(5);
        List items = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.providerService.getProvider(providerKey)).thenReturn((Object)provider);
        Mockito.when((Object)this.runtimeProvisioningService.executeQuery(RuntimeQueryBuilder.newInstance().withRuntimeName(RUNTIME_ID).build())).thenReturn((Object)items);
        Mockito.when((Object)items.isEmpty()).thenReturn((Object)true);
        Input expectedInput = PipelineInputBuilder.newInstance().withProvider(providerKey).withRuntimeName(RUNTIME_ID).withParams(params).build();
        this.service.createRuntime(providerKey, RUNTIME_ID, PIPELINE_KEY, params);
        ((PipelineServiceBackend)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).runPipeline(PIPELINE, expectedInput, true);
    }

    @Test
    public void testCreateRuntimeWhenProviderNotExists() {
        ProviderTypeKey providerTypeKey = new ProviderTypeKey("PROVIDER_NAME", "PROVIDER_VERSION");
        ProviderKey providerKey = new ProviderKey(providerTypeKey, "PROVIDER_ID");
        this.expectedException.expectMessage("No provider was found for providerKey: " + providerKey);
        this.service.createRuntime(providerKey, RUNTIME_ID, PIPELINE_KEY, null);
        ((PipelineServiceBackend)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.never())).runPipeline(Mockito.anyString(), (Input)Matchers.any(Input.class), Mockito.eq((boolean)true));
    }

    @Test
    public void testCreateRuntimeWhenProviderExistsButRuntimeNameExitsts() {
        Provider provider = (Provider)Mockito.mock(Provider.class);
        ProviderTypeKey providerTypeKey = new ProviderTypeKey("PROVIDER_NAME", "PROVIDER_VERSION");
        ProviderKey providerKey = new ProviderKey(providerTypeKey, "PROVIDER_ID");
        List items = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.providerService.getProvider(providerKey)).thenReturn((Object)provider);
        Mockito.when((Object)this.runtimeProvisioningService.executeQuery(RuntimeQueryBuilder.newInstance().withRuntimeName(RUNTIME_ID).build())).thenReturn((Object)items);
        Mockito.when((Object)items.isEmpty()).thenReturn((Object)false);
        this.expectedException.expectMessage("A runtime with the given name already exists: RUNTIME_ID");
        this.service.createRuntime(providerKey, RUNTIME_ID, PIPELINE_KEY, (Map)Mockito.mock(Map.class));
        ((PipelineServiceBackend)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.never())).runPipeline(Mockito.anyString(), (Input)Matchers.any(Input.class), Mockito.eq((boolean)true));
    }

    @Test
    public void testCreateRuntimeWhenUnExpectedError() {
        Provider provider = (Provider)Mockito.mock(Provider.class);
        ProviderTypeKey providerTypeKey = new ProviderTypeKey("PROVIDER_NAME", "PROVIDER_VERSION");
        ProviderKey providerKey = new ProviderKey(providerTypeKey, "PROVIDER_ID");
        Mockito.when((Object)this.providerService.getProvider(providerKey)).thenReturn((Object)provider);
        Mockito.when((Object)this.pipelineService.runPipeline(Mockito.anyString(), (Input)Matchers.any(Input.class), Mockito.eq((boolean)true))).thenThrow(new Throwable[]{new RuntimeException("ERROR_MESSAGE")});
        this.expectedException.expectMessage("ERROR_MESSAGE");
        this.service.createRuntime(providerKey, "irrelevant for the test", (PipelineKey)Mockito.mock(PipelineKey.class), (Map)Mockito.mock(Map.class));
    }

    @Test
    public void testStopPipelineExecution() {
        PipelineExecutionTraceKey pipelineExecutionTraceKey = new PipelineExecutionTraceKey(PIPELINE_EXECUTION_ID);
        this.service.stopPipelineExecution(pipelineExecutionTraceKey);
        ((PipelineServiceBackend)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).stopPipelineExecution(PIPELINE_EXECUTION_ID);
        ((EventSourceMock)Mockito.verify(this.pipelineExecutionChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new PipelineExecutionChangeEvent(PipelineExecutionChange.STOPPED, pipelineExecutionTraceKey));
    }

    @Test
    public void testDeletePipelineExecution() {
        PipelineExecutionTraceKey pipelineExecutionTraceKey = new PipelineExecutionTraceKey(PIPELINE_EXECUTION_ID);
        this.service.deletePipelineExecution(pipelineExecutionTraceKey);
        ((PipelineServiceBackend)Mockito.verify((Object)this.pipelineService, (VerificationMode)Mockito.times((int)1))).deletePipelineExecution(PIPELINE_EXECUTION_ID);
        ((EventSourceMock)Mockito.verify(this.pipelineExecutionChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new PipelineExecutionChangeEvent(PipelineExecutionChange.DELETED, pipelineExecutionTraceKey));
    }

    @Test
    public void testStopRuntime() {
        ProviderKey providerKey = (ProviderKey)Mockito.mock(ProviderKey.class);
        RuntimeKey runtimeKey = new RuntimeKey(providerKey, RUNTIME_ID);
        this.service.stopRuntime(runtimeKey);
        ((RuntimeProvisioningServiceBackend)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).stopRuntime(RUNTIME_ID);
        ((EventSourceMock)Mockito.verify(this.runtimeChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new RuntimeChangeEvent(RuntimeChange.STOPPED, runtimeKey));
    }

    @Test
    public void testStartRuntime() {
        ProviderKey providerKey = (ProviderKey)Mockito.mock(ProviderKey.class);
        RuntimeKey runtimeKey = new RuntimeKey(providerKey, RUNTIME_ID);
        this.service.startRuntime(runtimeKey);
        ((RuntimeProvisioningServiceBackend)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).startRuntime(RUNTIME_ID);
        ((EventSourceMock)Mockito.verify(this.runtimeChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new RuntimeChangeEvent(RuntimeChange.STARTED, runtimeKey));
    }

    @Test
    public void testDeleteRuntimeNotForced() {
        this.testDeleteRuntime(false);
    }

    @Test
    public void testDeleteRuntimeForced() {
        this.testDeleteRuntime(true);
    }

    private void testDeleteRuntime(boolean forced) {
        ProviderKey providerKey = (ProviderKey)Mockito.mock(ProviderKey.class);
        RuntimeKey runtimeKey = new RuntimeKey(providerKey, RUNTIME_ID);
        this.service.deleteRuntime(runtimeKey, forced);
        ((RuntimeProvisioningServiceBackend)Mockito.verify((Object)this.runtimeProvisioningService, (VerificationMode)Mockito.times((int)1))).destroyRuntime(RUNTIME_ID, forced);
        ((EventSourceMock)Mockito.verify(this.runtimeChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new RuntimeChangeEvent(RuntimeChange.DELETED, runtimeKey));
    }

    private List<RuntimeQueryResultItem> mockRuntimeQueryResultItemList(int count) {
        ArrayList<RuntimeQueryResultItem> items = new ArrayList<RuntimeQueryResultItem>();
        for (int i = 0; i < count; ++i) {
            items.add(this.mockRuntimeQueryResultItem(Integer.toString(i), i));
        }
        return items;
    }

    private Collection<RuntimeListItem> buildExpectedResult(List<RuntimeQueryResultItem> resultItems) {
        Collection result = resultItems.stream().map(item -> RuntimeListItemBuilder.newInstance().withItem(item).build()).collect(Collectors.toList());
        return result;
    }

    private RuntimeQueryResultItem mockRuntimeQueryResultItem(String suffix, int stageItemsCount) {
        RuntimeQueryResultItem item = new RuntimeQueryResultItem();
        item.setProviderId("RuntimeQueryResultItem.providerId." + suffix);
        item.setProviderTypeName("RuntimeQueryResultItem.providerTypeName." + suffix);
        item.setProviderVersion("RuntimeQueryResultItem.providerVersion." + suffix);
        item.setPipelineId("RuntimeQueryResultItem.pipelineId." + suffix);
        item.setPipelineExecutionId("RuntimeQueryResultItem.pipelineExecutionId." + suffix);
        item.setPipelineStatus("RUNNING");
        item.setPipelineError("RuntimeQueryResultItem.pipelineError." + suffix);
        item.setPipelineStageItems(RuntimeListItemBuilderTest.mockPipelineStageItemList(stageItemsCount));
        item.setRuntimeId("RuntimeQueryResultItem.runtimeId." + suffix);
        item.setRuntimeName("RuntimeQueryResultItem.runtimeName." + suffix);
        item.setRuntimeStatus("RUNNING");
        item.setStartedAt("RuntimeQueryResultItem.startedAt." + suffix);
        item.setRuntimeEndpoint("RuntimeQueryResultItem.runtimeEndpoint." + suffix);
        return item;
    }

    private List<String> mockPipelineNames(int count) {
        ArrayList<String> pipelines = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            pipelines.add("Pipeline." + Integer.toString(i));
        }
        return pipelines;
    }

    private List<PipelineKey> mockPipelineKeys(List<String> pipelineNames) {
        return pipelineNames.stream().map(PipelineKey::new).collect(Collectors.toList());
    }
}

