/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service.converter.impl;

import org.guvnor.ala.ui.backend.service.converter.ProviderConfigConverter;
import org.guvnor.ala.ui.backend.service.converter.impl.ProviderConverterFactoryImpl;
import org.guvnor.ala.ui.backend.service.handler.BackendProviderHandler;
import org.guvnor.ala.ui.backend.service.handler.BackendProviderHandlerRegistry;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProviderConverterFactoryImplTest {
    private static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    @Mock
    private BackendProviderHandlerRegistry handlerRegistry;
    @Mock
    private BackendProviderHandler providerHandler;
    @Mock
    private ProviderConfigConverter configConverter;
    private ProviderConverterFactoryImpl converterFactory;
    @Mock
    private ProviderTypeKey providerTypeKey;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.converterFactory = new ProviderConverterFactoryImpl(this.handlerRegistry);
    }

    @Test
    public void testGetProviderConfigConverterWhenHandlerConfigured() {
        Mockito.when((Object)this.handlerRegistry.ensureHandler(this.providerTypeKey)).thenReturn((Object)this.providerHandler);
        Mockito.when((Object)this.providerHandler.getProviderConfigConverter()).thenReturn((Object)this.configConverter);
        Assert.assertEquals((Object)this.configConverter, (Object)this.converterFactory.getProviderConfigConverter(this.providerTypeKey));
    }

    @Test
    public void testGetProviderConfigConverterWhenHandlerNotConfigured() {
        Mockito.when((Object)this.handlerRegistry.ensureHandler(this.providerTypeKey)).thenThrow(new Throwable[]{new RuntimeException(ERROR_MESSAGE)});
        this.expectedException.expectMessage(ERROR_MESSAGE);
        this.converterFactory.getProviderConfigConverter(this.providerTypeKey);
    }

    @Test
    public void testGetProviderConverter() {
        Assert.assertNotNull((Object)this.converterFactory.getProviderConverter());
    }
}

