/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service.handler;

import javax.enterprise.inject.Instance;
import org.guvnor.ala.ui.backend.service.handler.BackendProviderHandler;
import org.guvnor.ala.ui.backend.service.handler.BackendProviderHandlerRegistry;
import org.guvnor.ala.ui.handler.AbstractProviderHandlerRegistryTest;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class BackendProviderHandlerRegistryTest
extends AbstractProviderHandlerRegistryTest<BackendProviderHandler> {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected BackendProviderHandlerRegistry createHandlerRegistry(Instance<BackendProviderHandler> handlerInstance) {
        return new BackendProviderHandlerRegistry(handlerInstance);
    }

    protected BackendProviderHandler mockHandler() {
        return (BackendProviderHandler)Mockito.mock(BackendProviderHandler.class);
    }

    @Test
    public void testEnsureHandlerForRegisteredProviderType() throws Exception {
        ProviderTypeKey providerTypeKey = (ProviderTypeKey)this.expectedKeys.get(0);
        BackendProviderHandler handler = ((BackendProviderHandlerRegistry)this.handlerRegistry).ensureHandler(providerTypeKey);
        Assert.assertEquals(this.expectedHandlers.get(0), (Object)handler);
    }

    @Test
    public void testEnsureHandlerForNonRegisteredProviderType() throws Exception {
        ProviderTypeKey providerTypeKey = (ProviderTypeKey)Mockito.mock(ProviderTypeKey.class);
        this.expectedException.expectMessage("BackendProviderHandler was not found for providerTypeKey: " + providerTypeKey);
        ((BackendProviderHandlerRegistry)this.handlerRegistry).ensureHandler(providerTypeKey);
    }
}

