/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.HashMap;
import java.util.Map;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.ui.backend.service.PipelineInputBuilder;
import org.guvnor.ala.ui.model.ProviderKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PipelineInputBuilderTest {
    private static final String RUNTIME = "RUNTIME";
    private static final String PROVIDER = "PROVIDER";
    private Map<String, String> params;
    private static final int PARAMS_COUNT = 5;
    @Mock
    private ProviderKey providerKey;

    @Before
    public void setUp() {
        Mockito.when((Object)this.providerKey.getId()).thenReturn((Object)PROVIDER);
        this.params = PipelineInputBuilderTest.mockParams(5);
    }

    @Test
    public void testBuild() {
        Input result = PipelineInputBuilder.newInstance().withProvider(this.providerKey).withParams(this.params).withRuntimeName(RUNTIME).build();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)RUNTIME, (Object)result.get((Object)"runtime-name"));
        Assert.assertEquals((Object)PROVIDER, (Object)result.get((Object)"provider-name"));
        this.params.forEach((name, value) -> Assert.assertEquals((Object)value, (Object)result.get(name)));
    }

    public static Map<String, String> mockParams(int count) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            params.put("param.name." + i, "param.value." + i);
        }
        return params;
    }
}

