/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.services.api.backend.RuntimeProvisioningServiceBackend;
import org.guvnor.ala.ui.backend.service.ProviderTypeServiceImpl;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.guvnor.ala.ui.preferences.ProvisioningPreferences;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class ProviderTypeServiceImplTest {
    private static final int PROVIDER_TYPES_COUNT = 5;
    @Mock
    private RuntimeProvisioningServiceBackend runtimeProvisioningService;
    @Mock
    private PreferenceScopeFactory scopeFactory;
    @Mock
    private PreferenceScope preferenceScope;
    @Mock
    private ProvisioningPreferences provisioningPreferences;
    @Mock
    private ProviderTypeServiceImpl service;
    private List<org.guvnor.ala.runtime.providers.ProviderType> providerTypesSpi;
    private List<ProviderType> pickedProviderTypes;

    @Before
    public void setUp() {
        this.providerTypesSpi = AlaSPITestCommons.mockProviderTypeListSPI((int)5);
        Mockito.when((Object)this.scopeFactory.createScope("global")).thenReturn((Object)this.preferenceScope);
        this.provisioningPreferences = (ProvisioningPreferences)Mockito.spy((Object)new ProvisioningPreferences(){
            {
                this.setProviderTypeEnablements(new HashMap());
            }

            public void load() {
            }

            public void save(PreferenceScope customScope) {
            }
        });
        Mockito.when((Object)this.runtimeProvisioningService.getProviderTypes(Integer.valueOf(ArgumentMatchers.anyInt()), Integer.valueOf(ArgumentMatchers.anyInt()), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenReturn(this.providerTypesSpi);
        this.service = new ProviderTypeServiceImpl(this.runtimeProvisioningService, this.provisioningPreferences, this.scopeFactory);
    }

    @Test
    public void testGetAvailableProviders() {
        Collection result = this.service.getAvailableProviderTypes();
        Assert.assertEquals((long)5L, (long)result.size());
        int i = 0;
        for (ProviderType providerType : result) {
            Assert.assertNotNull((Object)providerType.getKey());
            Assert.assertEquals((Object)this.providerTypesSpi.get(i).getProviderTypeName(), (Object)((ProviderTypeKey)providerType.getKey()).getId());
            Assert.assertEquals((Object)this.providerTypesSpi.get(i).getVersion(), (Object)((ProviderTypeKey)providerType.getKey()).getVersion());
            ++i;
        }
    }

    @Test
    public void testGetProviderTypeExisting() {
        org.guvnor.ala.runtime.providers.ProviderType providerTypeSpi = this.providerTypesSpi.get(2);
        ProviderTypeKey providerTypeKey = new ProviderTypeKey(providerTypeSpi.getProviderTypeName(), providerTypeSpi.getVersion());
        ProviderType providerType = this.service.getProviderType(providerTypeKey);
        Assert.assertNotNull((Object)providerType);
        Assert.assertEquals((Object)providerTypeSpi.getProviderTypeName(), (Object)((ProviderTypeKey)providerType.getKey()).getId());
        Assert.assertEquals((Object)providerTypeSpi.getVersion(), (Object)((ProviderTypeKey)providerType.getKey()).getVersion());
    }

    @Test
    public void testGetProviderTypeNotExisting() {
        ProviderTypeKey providerTypeKey = new ProviderTypeKey("NonExisting", "NonExisting");
        ProviderType providerType = this.service.getProviderType(providerTypeKey);
        Assert.assertNull((Object)providerType);
    }

    @Test
    public void testGetEnabledProviderTypes() {
        this.pickSomeProviders();
        this.pickedProviderTypes.forEach(providerType -> this.provisioningPreferences.getProviderTypeEnablements().put(providerType, Boolean.TRUE));
        Collection result = this.service.getEnabledProviderTypes();
        Assert.assertEquals((long)this.pickedProviderTypes.size(), (long)result.size());
        this.pickedProviderTypes.forEach(providerType -> Assert.assertTrue((boolean)result.contains(providerType)));
        ((ProvisioningPreferences)Mockito.verify((Object)this.provisioningPreferences, (VerificationMode)Mockito.times((int)1))).load();
    }

    @Test
    public void testEnableProviderTypes() {
        this.pickSomeProviders();
        this.pickedProviderTypes.forEach(providerType -> this.provisioningPreferences.getProviderTypeEnablements().put(providerType, Boolean.FALSE));
        this.service.enableProviderTypes(this.pickedProviderTypes);
        this.pickedProviderTypes.forEach(providerType -> Assert.assertTrue((boolean)((Boolean)this.provisioningPreferences.getProviderTypeEnablements().get(providerType))));
        ((ProvisioningPreferences)Mockito.verify((Object)this.provisioningPreferences, (VerificationMode)Mockito.times((int)this.pickedProviderTypes.size()))).save(this.preferenceScope);
    }

    @Test
    public void testDisableProviderType() {
        this.pickSomeProviders();
        this.pickSomeProviders();
        this.pickedProviderTypes.forEach(providerType -> this.provisioningPreferences.getProviderTypeEnablements().put(providerType, Boolean.TRUE));
        ProviderType providerTypeToDisable = this.pickedProviderTypes.get(0);
        this.service.disableProviderType(providerTypeToDisable);
        Assert.assertFalse((boolean)((Boolean)this.provisioningPreferences.getProviderTypeEnablements().get(providerTypeToDisable)));
        ((ProvisioningPreferences)Mockito.verify((Object)this.provisioningPreferences, (VerificationMode)Mockito.times((int)1))).save(this.preferenceScope);
    }

    @Test
    public void testGetProviderTypesStatus() {
        Map initialStatusMap = this.service.getProviderTypesStatus();
        Assert.assertEquals((long)5L, (long)initialStatusMap.size());
        initialStatusMap.values().forEach(status -> Assert.assertEquals((Object)status, (Object)ProviderTypeStatus.DISABLED));
        this.pickSomeProviders();
        this.service.enableProviderTypes(this.pickedProviderTypes);
        Map currentStatusMap = this.service.getProviderTypesStatus();
        Assert.assertEquals((long)5L, (long)currentStatusMap.size());
        this.pickedProviderTypes.forEach(enabledProvider -> Assert.assertEquals((Object)ProviderTypeStatus.ENABLED, currentStatusMap.get(this.pickedProviderTypes.get(0))));
        long expectedDisabled = 5 - this.pickedProviderTypes.size();
        long currentDisabled = currentStatusMap.values().stream().filter(status -> status == ProviderTypeStatus.DISABLED).count();
        Assert.assertEquals((long)expectedDisabled, (long)currentDisabled);
    }

    private void pickSomeProviders() {
        Collection providerTypes = this.service.getAvailableProviderTypes();
        Iterator it = providerTypes.iterator();
        this.pickedProviderTypes = new ArrayList<ProviderType>();
        this.pickedProviderTypes.add((ProviderType)it.next());
        this.pickedProviderTypes.add((ProviderType)it.next());
    }
}

