/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.Collection;
import org.guvnor.ala.ui.backend.service.ProvisioningScreensServiceImpl;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProvidersInfo;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.RuntimesInfo;
import org.guvnor.ala.ui.service.ProviderService;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.guvnor.ala.ui.service.RuntimeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ProvisioningScreensServiceImplTest {
    @Mock
    private ProviderTypeService providerTypeService;
    @Mock
    private ProviderService providerService;
    @Mock
    private RuntimeService runtimeService;
    private ProvisioningScreensServiceImpl service;
    @Mock
    private ProviderTypeKey providerTypeKey;
    @Mock
    private ProviderType providerType;
    @Mock
    private ProviderKey providerKey;
    @Mock
    private Provider provider;
    @Mock
    private Collection<ProviderKey> providerKeys;
    @Mock
    private Collection<RuntimeListItem> runtimeListItems;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.service = new ProvisioningScreensServiceImpl(this.providerTypeService, this.providerService, this.runtimeService);
    }

    @Test
    public void testGetProvidersInfoProviderTypeExisting() {
        Mockito.when((Object)this.providerTypeService.getProviderType(this.providerTypeKey)).thenReturn((Object)this.providerType);
        Mockito.when((Object)this.providerService.getProvidersKey(this.providerType)).thenReturn(this.providerKeys);
        ProvidersInfo providersInfo = this.service.getProvidersInfo(this.providerTypeKey);
        Assert.assertNotNull((Object)providersInfo);
        Assert.assertEquals((Object)this.providerType, (Object)providersInfo.getProviderType());
        Assert.assertEquals(this.providerKeys, (Object)providersInfo.getProvidersKey());
        ((ProviderTypeService)Mockito.verify((Object)this.providerTypeService, (VerificationMode)Mockito.times((int)1))).getProviderType(this.providerTypeKey);
        ((ProviderService)Mockito.verify((Object)this.providerService, (VerificationMode)Mockito.times((int)1))).getProvidersKey(this.providerType);
    }

    @Test
    public void testGetProvidersInfoProviderTypeNotExisting() {
        Mockito.when((Object)this.providerTypeService.getProviderType(this.providerTypeKey)).thenReturn(null);
        ProvidersInfo providersInfo = this.service.getProvidersInfo(this.providerTypeKey);
        Assert.assertNull((Object)providersInfo);
        ((ProviderTypeService)Mockito.verify((Object)this.providerTypeService, (VerificationMode)Mockito.times((int)1))).getProviderType(this.providerTypeKey);
        ((ProviderService)Mockito.verify((Object)this.providerService, (VerificationMode)Mockito.never())).getProvidersKey(this.providerType);
    }

    @Test
    public void testGetRuntimesInfoProviderExisting() {
        Mockito.when((Object)this.providerService.getProvider(this.providerKey)).thenReturn((Object)this.provider);
        Mockito.when((Object)this.runtimeService.getRuntimeItems(this.providerKey)).thenReturn(this.runtimeListItems);
        RuntimesInfo info = this.service.getRuntimesInfo(this.providerKey);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)this.provider, (Object)info.getProvider());
        Assert.assertEquals(this.runtimeListItems, (Object)info.getRuntimeItems());
        ((ProviderService)Mockito.verify((Object)this.providerService, (VerificationMode)Mockito.times((int)1))).getProvider(this.providerKey);
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).getRuntimeItems(this.providerKey);
    }

    @Test
    public void testGetRuntimesInfoProviderNotExisting() {
        Mockito.when((Object)this.providerService.getProvider(this.providerKey)).thenReturn(null);
        RuntimesInfo info = this.service.getRuntimesInfo(this.providerKey);
        Assert.assertNull((Object)info);
        ((ProviderService)Mockito.verify((Object)this.providerService, (VerificationMode)Mockito.times((int)1))).getProvider(this.providerKey);
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.never())).getRuntimeItems(this.providerKey);
    }

    @Test
    public void testHasRuntimesTrue() {
        Collection runtimes = (Collection)Mockito.mock(Collection.class);
        Mockito.when((Object)this.runtimeService.getRuntimeItems(this.providerKey)).thenReturn((Object)runtimes);
        Mockito.when((Object)runtimes.isEmpty()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.service.hasRuntimes(this.providerKey));
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).getRuntimeItems(this.providerKey);
    }

    @Test
    public void testHasRuntimesFalse() {
        Collection runtimes = (Collection)Mockito.mock(Collection.class);
        Mockito.when((Object)this.runtimeService.getRuntimeItems(this.providerKey)).thenReturn((Object)runtimes);
        Mockito.when((Object)runtimes.isEmpty()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.service.hasRuntimes(this.providerKey));
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).getRuntimeItems(this.providerKey);
    }
}

