/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.ArrayList;
import org.guvnor.ala.services.api.PipelineStageItem;
import org.guvnor.ala.services.api.RuntimeQueryResultItem;
import org.guvnor.ala.services.api.itemlist.PipelineStageItemList;
import org.guvnor.ala.ui.backend.service.RuntimeListItemBuilder;
import org.guvnor.ala.ui.model.PipelineExecutionTrace;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.Runtime;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.model.Stage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RuntimeListItemBuilderTest {
    private static final int STAGE_ITEMS_COUNT = 7;
    private static final String RUNTIME_NAME = "RUNTIME_NAME";
    private static final String RUNTIME_ID = "RUNTIME_ID";
    private static final String PROVIDER_ID = "PROVIDER_ID";
    private static final String PROVIDER_NAME = "PROVIDER_NAME";
    private static final String PROVIDER_VERSION = "PROVIDER_VERSION";
    private static final String RUNTIME_ENDPOINT = "RUNTIME_ENDPOINT";
    private static final String RUNTIME_STARTED_AT = "RUNTIME_STARTED_AT";
    private static final String RUNTIME_STATUS = "RUNTIME_STATUS";
    private static final String PIPELINE_EXECUTION_ID = "PIPELINE_EXECUTION_ID";
    private static final String PIPELINE_ID = "PIPELINE_ID";
    private static final String PIPELINE_ERROR = "PIPELINE_ERROR";
    private static final String PIPELINE_ERROR_DETAIL = "PIPELINE_ERROR_DETAIL";
    private RuntimeQueryResultItem queryResultItem;
    private PipelineStageItemList stageItemList;

    @Before
    public void setUp() {
        this.queryResultItem = new RuntimeQueryResultItem();
    }

    @Test
    public void testBuildItemLabelForRuntime() {
        this.queryResultItem.setRuntimeName(RUNTIME_NAME);
        RuntimeListItem result = RuntimeListItemBuilder.newInstance().withItem(this.queryResultItem).build();
        Assert.assertEquals((Object)RUNTIME_NAME, (Object)result.getItemLabel());
    }

    @Test
    public void testBuildItemLabelForRuntimeName() {
        this.queryResultItem.setRuntimeName(RUNTIME_ID);
        RuntimeListItem result = RuntimeListItemBuilder.newInstance().withItem(this.queryResultItem).build();
        Assert.assertEquals((Object)RUNTIME_ID, (Object)result.getItemLabel());
    }

    @Test
    public void testBuildRuntimeWithNoPipelineExecution() {
        this.prepareRuntime();
        RuntimeListItem result = RuntimeListItemBuilder.newInstance().withItem(this.queryResultItem).build();
        Assert.assertTrue((boolean)result.isRuntime());
        Assert.assertNotNull((Object)result.getRuntime());
        Assert.assertNull((Object)result.getPipelineTrace());
        this.assertRuntime(result.getRuntime());
    }

    @Test
    public void testBuildRuntimeWithPipelineExecution() {
        this.prepareRuntime();
        this.preparePipelineTrace();
        RuntimeListItem result = RuntimeListItemBuilder.newInstance().withItem(this.queryResultItem).build();
        Assert.assertTrue((boolean)result.isRuntime());
        Assert.assertNotNull((Object)result.getRuntime());
        Assert.assertNotNull((Object)result.getRuntime().getPipelineTrace());
        Assert.assertNull((Object)result.getPipelineTrace());
        this.assertRuntime(result.getRuntime());
        this.assertPipelineTrace(result.getRuntime().getPipelineTrace());
    }

    @Test
    public void testPipelineTraceBuild() {
        this.preparePipelineTrace();
        RuntimeListItem result = RuntimeListItemBuilder.newInstance().withItem(this.queryResultItem).build();
        Assert.assertFalse((boolean)result.isRuntime());
        Assert.assertNotNull((Object)result.getPipelineTrace());
        Assert.assertNull((Object)result.getRuntime());
        this.assertPipelineTrace(result.getPipelineTrace());
    }

    private void prepareRuntime() {
        this.queryResultItem.setRuntimeId(RUNTIME_ID);
        this.queryResultItem.setProviderTypeName(PROVIDER_NAME);
        this.queryResultItem.setProviderVersion(PROVIDER_VERSION);
        this.queryResultItem.setProviderId(PROVIDER_ID);
        this.queryResultItem.setRuntimeEndpoint(RUNTIME_ENDPOINT);
        this.queryResultItem.setStartedAt(RUNTIME_STARTED_AT);
        this.queryResultItem.setRuntimeStatus(RUNTIME_STATUS);
    }

    private void assertRuntime(Runtime runtime) {
        Assert.assertEquals((Object)RUNTIME_ID, (Object)((RuntimeKey)runtime.getKey()).getId());
        Assert.assertEquals((Object)PROVIDER_NAME, (Object)((RuntimeKey)runtime.getKey()).getProviderKey().getProviderTypeKey().getId());
        Assert.assertEquals((Object)PROVIDER_VERSION, (Object)((RuntimeKey)runtime.getKey()).getProviderKey().getProviderTypeKey().getVersion());
        Assert.assertEquals((Object)PROVIDER_NAME, (Object)((RuntimeKey)runtime.getKey()).getProviderKey().getProviderTypeKey().getId());
        Assert.assertEquals((Object)PROVIDER_ID, (Object)((RuntimeKey)runtime.getKey()).getProviderKey().getId());
        Assert.assertEquals((Object)RUNTIME_ENDPOINT, (Object)runtime.getEndpoint());
        Assert.assertEquals((Object)RUNTIME_STARTED_AT, (Object)runtime.getCreatedDate());
        Assert.assertEquals((Object)RUNTIME_STATUS, (Object)runtime.getStatus());
    }

    private void preparePipelineTrace() {
        this.queryResultItem.setPipelineId(PIPELINE_ID);
        this.queryResultItem.setPipelineExecutionId(PIPELINE_EXECUTION_ID);
        this.queryResultItem.setPipelineStatus(PipelineStatus.RUNNING.name());
        this.queryResultItem.setPipelineError(PIPELINE_ERROR);
        this.queryResultItem.setPipelineErrorDetail(PIPELINE_ERROR_DETAIL);
        this.stageItemList = RuntimeListItemBuilderTest.mockPipelineStageItemList(7);
        this.queryResultItem.setPipelineStageItems(this.stageItemList);
    }

    private void assertPipelineTrace(PipelineExecutionTrace trace) {
        Assert.assertEquals((Object)PIPELINE_ID, (Object)((PipelineKey)trace.getPipeline().getKey()).getId());
        Assert.assertEquals((Object)PIPELINE_EXECUTION_ID, (Object)((PipelineExecutionTraceKey)trace.getKey()).getId());
        Assert.assertEquals((Object)PipelineStatus.RUNNING, (Object)trace.getPipelineStatus());
        Assert.assertEquals((Object)PIPELINE_ERROR, (Object)trace.getPipelineError().getError());
        Assert.assertEquals((Object)PIPELINE_ERROR_DETAIL, (Object)trace.getPipelineError().getErrorDetail());
        Assert.assertEquals((long)this.stageItemList.getItems().size(), (long)trace.getPipeline().getStages().size());
        for (int i = 0; i < 7; ++i) {
            PipelineStageItem stageItem = (PipelineStageItem)this.stageItemList.getItems().get(i);
            Stage stage = (Stage)trace.getPipeline().getStages().get(i);
            Assert.assertEquals((Object)stageItem.getName(), (Object)stage.getName());
            Assert.assertEquals((Object)stageItem.getStatus(), (Object)trace.getStageStatus(stage.getName()).name());
            Assert.assertEquals((Object)stageItem.getStageError(), (Object)trace.getStageError(stage.getName()).getError());
            Assert.assertEquals((Object)stageItem.getStageErrorDetail(), (Object)trace.getStageError(stage.getName()).getErrorDetail());
        }
    }

    public static PipelineStageItemList mockPipelineStageItemList(int count) {
        ArrayList<PipelineStageItem> stageItems = new ArrayList<PipelineStageItem>();
        for (int i = 0; i < count; ++i) {
            stageItems.add(RuntimeListItemBuilderTest.mockStageItem(Integer.toString(i)));
        }
        return new PipelineStageItemList(stageItems);
    }

    public static PipelineStageItem mockStageItem(String suffix) {
        return new PipelineStageItem("PipelineStageItem.name." + suffix, "RUNNING", "PipelineStageItem.stageError." + suffix, "PipelineStageItem.stageErrorDetail." + suffix);
    }
}

