/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.guvnor.ala.ui.backend.service.SourceServiceImpl;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class SourceServiceImplTest {
    private static final int OU_SIZE = 7;
    private static final int REPOSITORIES_SIZE = 10;
    private static final String OU_NAME = "OU_NAME";
    private static final String REPO_NAME = "REPO_NAME";
    private static final String BRANCH_NAME = "BRANCH_NAME";
    private static final Space SPACE = new Space("OU_NAME");
    @Mock
    private OrganizationalUnitService organizationalUnitService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private ModuleService<? extends Module> moduleService;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private User identity;
    private SourceServiceImpl service;
    private List<OrganizationalUnit> organizationalUnits;

    @Before
    public void setUp() {
        this.organizationalUnits = this.mockOrganizationalUnits(OU_NAME, 7);
        this.service = new SourceServiceImpl(this.organizationalUnitService, this.repositoryService, this.moduleService, this.authorizationManager, this.identity);
    }

    @Test
    public void testGetOrganizationalUnits() {
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        List expectedResult = this.organizationalUnits.stream().map(OrganizationalUnit::getName).collect(Collectors.toList());
        Collection result = this.service.getOrganizationUnits();
        Assert.assertEquals(expectedResult, (Object)result);
    }

    @Test
    public void testGetRepositories() {
        List<Repository> repositories = this.mockRepositories("RepoName.", 10);
        OrganizationalUnit organizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        Mockito.when((Object)organizationalUnit.getName()).thenReturn((Object)OU_NAME);
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnit(OU_NAME)).thenReturn(null);
        Collection result = this.service.getRepositories(OU_NAME);
        Assert.assertTrue((boolean)result.isEmpty());
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnit(OU_NAME)).thenReturn((Object)organizationalUnit);
        Mockito.when((Object)organizationalUnit.getRepositories()).thenReturn(repositories);
        result = this.service.getRepositories(OU_NAME);
        Assert.assertTrue((boolean)result.isEmpty());
        ArrayList<Integer> authorizedIndexes = new ArrayList<Integer>();
        ArrayList authorizedNames = new ArrayList();
        authorizedIndexes.add(1);
        authorizedIndexes.add(4);
        authorizedIndexes.add(6);
        authorizedIndexes.forEach(index -> {
            Mockito.when((Object)this.authorizationManager.authorize((Resource)repositories.get((int)index), this.identity)).thenReturn((Object)true);
            authorizedNames.add(((Repository)repositories.get((int)index)).getAlias());
        });
        result = this.service.getRepositories(OU_NAME);
        Assert.assertEquals(authorizedNames, (Object)result);
    }

    @Test
    public void testGetBranches() {
        ArrayList<Branch> branches = new ArrayList<Branch>();
        branches.add(new Branch("branch1", (Path)Mockito.mock(Path.class)));
        branches.add(new Branch("branch2", (Path)Mockito.mock(Path.class)));
        branches.add(new Branch("branch3", (Path)Mockito.mock(Path.class)));
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repository.getBranches()).thenReturn(branches);
        Mockito.when((Object)this.repositoryService.getRepositoryFromSpace(SPACE, REPO_NAME)).thenReturn((Object)repository);
        Collection result = this.service.getBranches(SPACE, REPO_NAME);
        ArrayList<String> originalBranchNames = new ArrayList<String>();
        for (Branch branch : branches) {
            originalBranchNames.add(branch.getName());
        }
        Assert.assertEquals(originalBranchNames, (Object)result);
    }

    @Test
    public void testProjects() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Branch branch = new Branch(BRANCH_NAME, (Path)Mockito.mock(Path.class));
        ((Repository)Mockito.doReturn(Optional.of(branch)).when((Object)repository)).getBranch((String)Mockito.eq((Object)BRANCH_NAME));
        Set modules = (Set)Mockito.mock(Set.class);
        Mockito.when((Object)this.repositoryService.getRepositoryFromSpace(SPACE, REPO_NAME)).thenReturn((Object)repository);
        Mockito.when((Object)this.moduleService.getAllModules(branch)).thenReturn((Object)modules);
        Collection result = this.service.getModules(SPACE, REPO_NAME, BRANCH_NAME);
        Assert.assertEquals((Object)modules, (Object)result);
    }

    private List<OrganizationalUnit> mockOrganizationalUnits(String suffix, int count) {
        ArrayList<OrganizationalUnit> result = new ArrayList<OrganizationalUnit>();
        for (int i = 0; i < count; ++i) {
            OrganizationalUnit ou = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
            Mockito.when((Object)ou.getName()).thenReturn((Object)(suffix + i));
            result.add(ou);
        }
        return result;
    }

    private List<Repository> mockRepositories(String suffix, int count) {
        ArrayList<Repository> result = new ArrayList<Repository>();
        for (int i = 0; i < count; ++i) {
            Repository repo = (Repository)Mockito.mock(Repository.class);
            Mockito.when((Object)repo.getAlias()).thenReturn((Object)(suffix + i));
            result.add(repo);
        }
        return result;
    }
}

