/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service.converter.impl;

import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.ui.backend.service.converter.ProviderConfigConverter;
import org.guvnor.ala.ui.backend.service.converter.impl.ProviderConverterImpl;
import org.guvnor.ala.ui.backend.service.handler.BackendProviderHandler;
import org.guvnor.ala.ui.backend.service.handler.BackendProviderHandlerRegistry;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProviderConverterImplTest {
    private static final String PROVIDER_ID = "PROVIDER_ID";
    private static final String PROVIDER_TYPE_NAME = "PROVIDER_TYPE_NAME";
    private static final String PROVIDER_VERSION = "PROVIDER_VERSION";
    private static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    @Mock
    private BackendProviderHandlerRegistry handlerRegistry;
    private ProviderConverterImpl converter;
    @Mock
    private BackendProviderHandler providerHandler;
    @Mock
    private ProviderConfigConverter providerConfigConverter;
    @Mock
    private Provider provider;
    @Mock
    private ProviderType providerType;
    @Mock
    private ProviderConfig providerConfig;
    private ProviderKey providerKey;
    private ProviderTypeKey providerTypeKey;
    @Mock
    private ProviderConfiguration providerConfiguration;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        Mockito.when((Object)this.providerType.getProviderTypeName()).thenReturn((Object)PROVIDER_TYPE_NAME);
        Mockito.when((Object)this.providerType.getVersion()).thenReturn((Object)PROVIDER_VERSION);
        Mockito.when((Object)this.provider.getId()).thenReturn((Object)PROVIDER_ID);
        Mockito.when((Object)this.provider.getProviderType()).thenReturn((Object)this.providerType);
        Mockito.when((Object)this.provider.getConfig()).thenReturn((Object)this.providerConfig);
        this.providerTypeKey = new ProviderTypeKey(PROVIDER_TYPE_NAME, PROVIDER_VERSION);
        this.providerKey = new ProviderKey(this.providerTypeKey, PROVIDER_ID);
        this.converter = new ProviderConverterImpl(this.handlerRegistry);
    }

    @Test
    public void testToModelWhenHandlerNotConfigured() {
        Mockito.when((Object)this.handlerRegistry.ensureHandler(this.providerTypeKey)).thenThrow(new Throwable[]{new RuntimeException(ERROR_MESSAGE)});
        this.expectedException.expectMessage(ERROR_MESSAGE);
        this.converter.toModel(this.provider);
    }

    @Test
    public void testToModelWhenHandlerIsConfigured() {
        Mockito.when((Object)this.handlerRegistry.ensureHandler(this.providerTypeKey)).thenReturn((Object)this.providerHandler);
        Mockito.when((Object)this.providerHandler.getProviderConfigConverter()).thenReturn((Object)this.providerConfigConverter);
        Mockito.when((Object)this.providerConfigConverter.toModel((Object)this.providerConfig)).thenReturn((Object)this.providerConfiguration);
        org.guvnor.ala.ui.model.Provider result = this.converter.toModel(this.provider);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)PROVIDER_ID, (Object)((ProviderKey)result.getKey()).getId());
        Assert.assertEquals((Object)PROVIDER_TYPE_NAME, (Object)((ProviderKey)result.getKey()).getProviderTypeKey().getId());
        Assert.assertEquals((Object)PROVIDER_VERSION, (Object)((ProviderKey)result.getKey()).getProviderTypeKey().getVersion());
        Assert.assertEquals((Object)result.getConfiguration(), (Object)this.providerConfiguration);
    }
}

