/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.provider.status.runtime;

import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenter;
import org.guvnor.ala.ui.client.provider.status.runtime.RuntimePresenterTest;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.events.PipelineExecutionChange;
import org.guvnor.ala.ui.events.PipelineExecutionChangeEvent;
import org.guvnor.ala.ui.events.RuntimeChange;
import org.guvnor.ala.ui.events.RuntimeChangeEvent;
import org.guvnor.ala.ui.model.PipelineError;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineStatus;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public class RuntimePresenterActionsTest
extends RuntimePresenterTest {
    private static final String SUCCESS_MESSAGE = "SUCCESS_MESSAGE";
    private static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    private static final String CONFIRM_MESSAGE = "CONFIRM_MESSAGE";
    private static final String CONFIRM_MESSAGE_2 = "CONFIRM_MESSAGE_2";
    private static final String CONFIRM_MESSAGE_3 = "CONFIRM_MESSAGE_3";
    private static final String TITLE = "TITLE";
    private static final String TITLE_2 = "TITLE_2";
    private static final String TITLE_3 = "TITLE_3";
    private static final String BUSY_POPUP_MESSAGE = "BUSY_POPUP_MESSAGE";
    private static final String BUSY_POPUP_MESSAGE_2 = "BUSY_POPUP_MESSAGE_2";
    private static final String PIPELINE_ERROR = "PIPELINE_ERROR";
    private static final String PIPELINE_ERROR_DETAIL = "PIPELINE_ERROR_DETAIL";
    @Mock
    private ErrorCallback<Message> defaultErrorCallback;
    private ArgumentCaptor<Exception> exceptionCaptor;
    private ArgumentCaptor<Command> yesCommandCaptor;
    private ArgumentCaptor<Command> noCommandCaptor;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Mockito.when((Object)this.popupHelper.getPopupErrorCallback()).thenReturn(this.defaultErrorCallback);
        this.exceptionCaptor = ArgumentCaptor.forClass(Exception.class);
        this.yesCommandCaptor = ArgumentCaptor.forClass(Command.class);
        this.noCommandCaptor = ArgumentCaptor.forClass(Command.class);
    }

    @Test
    public void testOnCurrentPipelineExecutionStopped() {
        this.preparePipelineExecutionTraceSetup();
        PipelineExecutionTraceKey currentKey = (PipelineExecutionTraceKey)this.trace.getKey();
        RuntimeListItem item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.presenter.setup(item);
        this.presenter.onPipelineExecutionChange(new PipelineExecutionChangeEvent(PipelineExecutionChange.STOPPED, currentKey));
        ((RuntimePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).refresh(currentKey);
    }

    @Test
    public void testOnOtherPipelineExecutionStopped() {
        this.preparePipelineExecutionTraceSetup();
        PipelineExecutionTraceKey otherKey = (PipelineExecutionTraceKey)Mockito.mock(PipelineExecutionTraceKey.class);
        RuntimeListItem item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.presenter.setup(item);
        this.presenter.onPipelineExecutionChange(new PipelineExecutionChangeEvent(PipelineExecutionChange.STOPPED, otherKey));
        ((RuntimePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).refresh((PipelineExecutionTraceKey)Matchers.any(PipelineExecutionTraceKey.class));
    }

    @Test
    public void testOnCurrentRuntimeStarted() {
        this.prepareRuntime();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        this.presenter.onRuntimeChangeEvent(new RuntimeChangeEvent(RuntimeChange.STARTED, currentKey));
        ((RuntimePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).refresh(currentKey);
    }

    @Test
    public void testOnOtherRuntimeStarted() {
        this.prepareRuntime();
        RuntimeKey otherKey = (RuntimeKey)Mockito.mock(RuntimeKey.class);
        this.presenter.onRuntimeChangeEvent(new RuntimeChangeEvent(RuntimeChange.STARTED, otherKey));
        ((RuntimePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).refresh((RuntimeKey)Matchers.any(RuntimeKey.class));
    }

    @Test
    public void testOnCurrentRuntimeStopped() {
        this.prepareRuntime();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        this.presenter.onRuntimeChangeEvent(new RuntimeChangeEvent(RuntimeChange.STOPPED, currentKey));
        ((RuntimePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).refresh(currentKey);
    }

    @Test
    public void testOnOtherRuntimeStopped() {
        this.prepareRuntime();
        RuntimeKey otherKey = (RuntimeKey)Mockito.mock(RuntimeKey.class);
        this.presenter.onRuntimeChangeEvent(new RuntimeChangeEvent(RuntimeChange.STOPPED, otherKey));
        ((RuntimePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).refresh((RuntimeKey)Matchers.any(RuntimeKey.class));
    }

    @Test
    public void testStartRuntimeSuccessful() {
        this.prepareRuntime();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        Mockito.when((Object)this.translationService.format("RuntimePresenter.RuntimeStartSuccessMessage", new Object[]{currentKey.getId()})).thenReturn((Object)SUCCESS_MESSAGE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeStartingMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE);
        this.presenter.startRuntime();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent(SUCCESS_MESSAGE, NotificationEvent.NotificationType.SUCCESS));
    }

    @Test
    public void testStartRuntimeFailed() {
        this.prepareRuntime();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        ((RuntimeService)Mockito.doThrow((Throwable)new RuntimeException(ERROR_MESSAGE)).when((Object)this.runtimeService)).startRuntime(currentKey);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeStartingMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE);
        this.presenter.startRuntime();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent, (VerificationMode)Mockito.times((int)0))).fire(Matchers.any(NotificationEvent.class));
        ((ErrorCallback)Mockito.verify(this.defaultErrorCallback, (VerificationMode)Mockito.times((int)1))).error(Matchers.any(Message.class), (Throwable)this.exceptionCaptor.capture());
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)((Exception)this.exceptionCaptor.getValue()).getMessage());
    }

    @Test
    public void testStopRuntimeConfirmNo() {
        this.prepareRuntimeStop();
        ((Command)this.noCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.never())).stopRuntime((RuntimeKey)Matchers.any(RuntimeKey.class));
    }

    @Test
    public void testStopRuntimeConfirmYesAndSuccessful() {
        this.prepareRuntimeStop();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        Mockito.when((Object)this.translationService.format("RuntimePresenter.RuntimeStopSuccessMessage", new Object[]{((RuntimeKey)this.item.getRuntime().getKey()).getId()})).thenReturn((Object)SUCCESS_MESSAGE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeStoppingMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).stopRuntime(currentKey);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent(SUCCESS_MESSAGE, NotificationEvent.NotificationType.SUCCESS));
    }

    @Test
    public void testStopRuntimeConfirmYesAndFailed() {
        this.prepareRuntimeStop();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeStoppingMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE);
        ((RuntimeService)Mockito.doThrow((Throwable)new RuntimeException(ERROR_MESSAGE)).when((Object)this.runtimeService)).stopRuntime(currentKey);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).stopRuntime(currentKey);
        ((ErrorCallback)Mockito.verify(this.defaultErrorCallback, (VerificationMode)Mockito.times((int)1))).error(Matchers.any(Message.class), (Throwable)this.exceptionCaptor.capture());
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)((Exception)this.exceptionCaptor.getValue()).getMessage());
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
    }

    private void prepareRuntimeStop() {
        this.prepareRuntime();
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmStopTitle")).thenReturn((Object)TITLE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmStopMessage")).thenReturn((Object)CONFIRM_MESSAGE);
        this.presenter.stopRuntime();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showYesNoPopup((String)Mockito.eq((Object)TITLE), (String)Mockito.eq((Object)CONFIRM_MESSAGE), (Command)this.yesCommandCaptor.capture(), (Command)this.noCommandCaptor.capture());
    }

    @Test
    public void testDeleteRuntimeConfirmNo() {
        this.prepareRuntimeDelete();
        ((Command)this.noCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.never())).deleteRuntime((RuntimeKey)Matchers.any(RuntimeKey.class), Mockito.anyBoolean());
    }

    @Test
    public void testDeleteRuntimeConfirmYesAndSuccessful() {
        this.prepareRuntimeDelete();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        Mockito.when((Object)this.translationService.format("RuntimePresenter.RuntimeDeleteSuccessMessage", new Object[]{((RuntimeKey)this.item.getRuntime().getKey()).getId()})).thenReturn((Object)SUCCESS_MESSAGE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeDeletingMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).deleteRuntime(currentKey, false);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent(SUCCESS_MESSAGE, NotificationEvent.NotificationType.SUCCESS));
    }

    @Test
    public void testDeleteRuntimeConfirmYesAndFailedAndDontForceDeletion() {
        this.prepareRuntimeDelete();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        RuntimeException deleteException = new RuntimeException(ERROR_MESSAGE);
        Mockito.when((Object)this.translationService.format("RuntimePresenter.RuntimeDeleteFailedMessage", new Object[]{ERROR_MESSAGE})).thenReturn((Object)CONFIRM_MESSAGE_2);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeDeleteFailedTitle")).thenReturn((Object)TITLE_2);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeDeletingMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE);
        ((RuntimeService)Mockito.doThrow((Throwable)deleteException).when((Object)this.runtimeService)).deleteRuntime(currentKey, false);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).deleteRuntime(currentKey, false);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showYesNoPopup((String)Mockito.eq((Object)TITLE_2), (String)Mockito.eq((Object)CONFIRM_MESSAGE_2), (Command)this.yesCommandCaptor.capture(), (Command)this.noCommandCaptor.capture());
        ((Command)this.noCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.never())).deleteRuntime(currentKey, true);
    }

    @Test
    public void testDeleteRuntimeConfirmYesAndFailedAndForceDeletion() {
        this.prepareRuntimeDelete();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        RuntimeException deleteException = new RuntimeException(ERROR_MESSAGE);
        Mockito.when((Object)this.translationService.format("RuntimePresenter.RuntimeDeleteFailedMessage", new Object[]{ERROR_MESSAGE})).thenReturn((Object)CONFIRM_MESSAGE_2);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeDeleteFailedTitle")).thenReturn((Object)TITLE_2);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmForcedDeleteTitle")).thenReturn((Object)TITLE_3);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmForcedDeleteMessage")).thenReturn((Object)CONFIRM_MESSAGE_3);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeDeletingMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeDeletingForcedMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE_2);
        ((RuntimeService)Mockito.doThrow((Throwable)deleteException).when((Object)this.runtimeService)).deleteRuntime(currentKey, false);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).deleteRuntime(currentKey, false);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showYesNoPopup((String)Mockito.eq((Object)TITLE_2), (String)Mockito.eq((Object)CONFIRM_MESSAGE_2), (Command)this.yesCommandCaptor.capture(), (Command)this.noCommandCaptor.capture());
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showYesNoPopup((String)Mockito.eq((Object)TITLE_3), (String)Mockito.eq((Object)CONFIRM_MESSAGE_3), (Command)this.yesCommandCaptor.capture(), (Command)this.noCommandCaptor.capture());
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).deleteRuntime(currentKey, true);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE_2);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)2))).hideBusyIndicator();
    }

    @Test
    public void testForceDeleteRuntimeConfirmNo() {
        this.prepareRuntimeForceDelete();
        ((Command)this.noCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.never())).deleteRuntime((RuntimeKey)Matchers.any(RuntimeKey.class), Mockito.anyBoolean());
    }

    @Test
    public void testForceDeleteRuntimeConfirmYesAndSuccessful() {
        this.prepareRuntimeForceDelete();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        Mockito.when((Object)this.translationService.format("RuntimePresenter.RuntimeDeleteSuccessMessage", new Object[]{((RuntimeKey)this.item.getRuntime().getKey()).getId()})).thenReturn((Object)SUCCESS_MESSAGE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeDeletingForcedMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).deleteRuntime(currentKey, true);
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent(SUCCESS_MESSAGE, NotificationEvent.NotificationType.SUCCESS));
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
    }

    @Test
    public void testForceDeleteRuntimeConfirmYesAndFailed() {
        this.prepareRuntimeForceDelete();
        RuntimeKey currentKey = (RuntimeKey)this.runtime.getKey();
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeDeletingForcedMessage")).thenReturn((Object)BUSY_POPUP_MESSAGE);
        ((RuntimeService)Mockito.doThrow((Throwable)new RuntimeException(ERROR_MESSAGE)).when((Object)this.runtimeService)).deleteRuntime(currentKey, true);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).deleteRuntime(currentKey, true);
        ((ErrorCallback)Mockito.verify(this.defaultErrorCallback, (VerificationMode)Mockito.times((int)1))).error(Matchers.any(Message.class), (Throwable)this.exceptionCaptor.capture());
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)((Exception)this.exceptionCaptor.getValue()).getMessage());
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(BUSY_POPUP_MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
    }

    private void prepareRuntimeDelete() {
        this.prepareRuntime();
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmDeleteTitle")).thenReturn((Object)TITLE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmDeleteMessage")).thenReturn((Object)CONFIRM_MESSAGE);
        this.presenter.deleteRuntime();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showYesNoPopup((String)Mockito.eq((Object)TITLE), (String)Mockito.eq((Object)CONFIRM_MESSAGE), (Command)this.yesCommandCaptor.capture(), (Command)this.noCommandCaptor.capture());
    }

    private void prepareRuntimeForceDelete() {
        this.prepareRuntime();
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmForcedDeleteTitle")).thenReturn((Object)TITLE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.RuntimeConfirmForcedDeleteMessage")).thenReturn((Object)CONFIRM_MESSAGE);
        this.presenter.forceDeleteRuntime();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showYesNoPopup((String)Mockito.eq((Object)TITLE), (String)Mockito.eq((Object)CONFIRM_MESSAGE), (Command)this.yesCommandCaptor.capture(), (Command)this.noCommandCaptor.capture());
    }

    @Test
    public void testStopPipelineConfirmNo() {
        this.preparePipelineStop();
        ((Command)this.noCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.never())).stopPipelineExecution((PipelineExecutionTraceKey)Matchers.any(PipelineExecutionTraceKey.class));
    }

    @Test
    public void testStopPipelineConfirmYesAndSuccessful() {
        this.preparePipelineStop();
        PipelineExecutionTraceKey currentKey = (PipelineExecutionTraceKey)this.trace.getKey();
        Mockito.when((Object)this.translationService.format("RuntimePresenter.PipelineExecutionStopSuccessMessage", new Object[]{currentKey.getId()})).thenReturn((Object)SUCCESS_MESSAGE);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).stopPipelineExecution(currentKey);
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent(SUCCESS_MESSAGE, NotificationEvent.NotificationType.SUCCESS));
    }

    @Test
    public void testStopPipelineConfirmYesAndFailed() {
        this.preparePipelineStop();
        PipelineExecutionTraceKey currentKey = (PipelineExecutionTraceKey)this.trace.getKey();
        ((RuntimeService)Mockito.doThrow((Throwable)new RuntimeException(ERROR_MESSAGE)).when((Object)this.runtimeService)).stopPipelineExecution(currentKey);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).stopPipelineExecution(currentKey);
        ((ErrorCallback)Mockito.verify(this.defaultErrorCallback, (VerificationMode)Mockito.times((int)1))).error(Matchers.any(Message.class), (Throwable)this.exceptionCaptor.capture());
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)((Exception)this.exceptionCaptor.getValue()).getMessage());
    }

    @Test
    public void testStopPipelineConfirmYesButWasARuntime() {
        this.prepareRuntime();
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmStopTitle")).thenReturn((Object)TITLE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmStopMessage")).thenReturn((Object)CONFIRM_MESSAGE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionAlreadyStoppedMessage")).thenReturn((Object)ERROR_MESSAGE);
        this.presenter.stopPipeline();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showYesNoPopup((String)Mockito.eq((Object)TITLE), (String)Mockito.eq((Object)CONFIRM_MESSAGE), (Command)this.yesCommandCaptor.capture(), (Command)this.noCommandCaptor.capture());
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showInformationPopup(ERROR_MESSAGE);
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.never())).stopPipelineExecution((PipelineExecutionTraceKey)Matchers.any(PipelineExecutionTraceKey.class));
    }

    private void preparePipelineStop() {
        this.preparePipeline();
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmStopTitle")).thenReturn((Object)TITLE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmStopMessage")).thenReturn((Object)CONFIRM_MESSAGE);
        this.presenter.stopPipeline();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showYesNoPopup((String)Mockito.eq((Object)TITLE), (String)Mockito.eq((Object)CONFIRM_MESSAGE), (Command)this.yesCommandCaptor.capture(), (Command)this.noCommandCaptor.capture());
    }

    @Test
    public void testDeletePipelineConfirmNo() {
        this.preparePipelineDelete();
        ((Command)this.noCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.never())).deletePipelineExecution((PipelineExecutionTraceKey)Matchers.any(PipelineExecutionTraceKey.class));
    }

    @Test
    public void testDeletePipelineConfirmYesAndSuccessful() {
        this.preparePipelineDelete();
        PipelineExecutionTraceKey currentKey = (PipelineExecutionTraceKey)this.trace.getKey();
        Mockito.when((Object)this.translationService.format("RuntimePresenter.PipelineExecutionDeleteSuccessMessage", new Object[]{currentKey.getId()})).thenReturn((Object)SUCCESS_MESSAGE);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).deletePipelineExecution(currentKey);
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new NotificationEvent(SUCCESS_MESSAGE, NotificationEvent.NotificationType.SUCCESS));
    }

    @Test
    public void testDeletePipelineConfirmYesAndFailed() {
        this.preparePipelineDelete();
        PipelineExecutionTraceKey currentKey = (PipelineExecutionTraceKey)this.trace.getKey();
        ((RuntimeService)Mockito.doThrow((Throwable)new RuntimeException(ERROR_MESSAGE)).when((Object)this.runtimeService)).deletePipelineExecution(currentKey);
        ((Command)this.yesCommandCaptor.getValue()).execute();
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)Mockito.times((int)1))).deletePipelineExecution(currentKey);
        ((ErrorCallback)Mockito.verify(this.defaultErrorCallback, (VerificationMode)Mockito.times((int)1))).error(Matchers.any(Message.class), (Throwable)this.exceptionCaptor.capture());
        Assert.assertEquals((Object)ERROR_MESSAGE, (Object)((Exception)this.exceptionCaptor.getValue()).getMessage());
    }

    private void preparePipelineDelete() {
        this.preparePipeline();
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmDeleteTitle")).thenReturn((Object)TITLE);
        Mockito.when((Object)this.translationService.getTranslation("RuntimePresenter.PipelineExecutionConfirmDeleteMessage")).thenReturn((Object)CONFIRM_MESSAGE);
        this.presenter.deletePipeline();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showYesNoPopup((String)Mockito.eq((Object)TITLE), (String)Mockito.eq((Object)CONFIRM_MESSAGE), (Command)this.yesCommandCaptor.capture(), (Command)this.noCommandCaptor.capture());
    }

    @Test
    public void testShowPipelineExecutionError() {
        this.trace = this.mockPipelineExecutionTrace("EXECUTION_ID", this.mockPipeline("PIPELINE_NAME", 10), (PipelineStatus)Mockito.mock(PipelineStatus.class), (PipelineStatus)Mockito.mock(PipelineStatus.class));
        this.trace.setPipelineStatus(PipelineStatus.ERROR);
        this.trace.setPipelineError(new PipelineError(PIPELINE_ERROR, PIPELINE_ERROR_DETAIL));
        this.item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.presenter.setup(this.item);
        this.presenter.showPipelineError();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showErrorPopup(PIPELINE_ERROR, PIPELINE_ERROR_DETAIL);
    }

    private void prepareRuntime() {
        this.runtime = this.mockRuntime();
        this.item = new RuntimeListItem("RUNTIME_NAME", this.runtime);
        this.presenter.setup(this.item);
    }

    private void preparePipeline() {
        this.trace = this.mockPipelineExecutionTrace("EXECUTION_ID", this.mockPipeline("PIPELINE_NAME", 10), (PipelineStatus)Mockito.mock(PipelineStatus.class), (PipelineStatus)Mockito.mock(PipelineStatus.class));
        this.item = new RuntimeListItem("RUNTIME_NAME", this.trace);
        this.presenter.setup(this.item);
    }
}

