/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.container;

import java.util.ArrayList;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.validation.ProvisioningClientValidationService;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.widget.artifact.ArtifactSelectorPresenter;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfig;
import org.guvnor.ala.ui.client.wizard.container.ContainerConfigPresenter;
import org.guvnor.ala.ui.service.ProvisioningValidationService;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerConfigPresenterTest {
    private static final String CONTAINER_NAME_VALUE = "CONTAINER_NAME_VALUE";
    private static final String GROUP_ID_VALUE = "GROUP_ID_VALUE";
    private static final String ARTIFACT_ID_VALUE = "ARTIFACT_ID_VALUE";
    private static final String VERSION_VALUE = "VERSION_VALUE";
    private static final String JAR_PATH = "JAR_PATH";
    private static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    @Mock
    private ContainerConfigPresenter.View view;
    @Mock
    private ArtifactSelectorPresenter artifactSelector;
    @Mock
    private ArtifactSelectorPresenter.View artifactSelectorView;
    @Mock
    private TranslationService translationService;
    @Mock
    private PopupHelper popupHelper;
    private CallerMock<M2RepoService> m2RepoServiceCaller;
    @Mock
    private M2RepoService m2RepoService;
    @Mock
    private ProvisioningValidationService provisioningValidationService;
    private Caller<ProvisioningValidationService> provisioningValidationServiceCaller;
    private ProvisioningClientValidationService provisioningClientValidationService;
    private ContainerConfigPresenter presenter;

    @Before
    public void setUp() {
        Mockito.when((Object)this.artifactSelector.getView()).thenReturn((Object)this.artifactSelectorView);
        this.m2RepoServiceCaller = (CallerMock)Mockito.spy((Object)new CallerMock((Object)this.m2RepoService));
        this.provisioningValidationServiceCaller = new CallerMock((Object)this.provisioningValidationService);
        this.provisioningClientValidationService = new ProvisioningClientValidationService(this.provisioningValidationServiceCaller);
        this.presenter = (ContainerConfigPresenter)Mockito.spy((Object)new ContainerConfigPresenter(this.view, this.artifactSelector, this.translationService, this.popupHelper, this.m2RepoServiceCaller, this.provisioningClientValidationService));
        this.presenter.init();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((ArtifactSelectorPresenter)Mockito.verify((Object)this.artifactSelector, (VerificationMode)Mockito.times((int)1))).setArtifactSelectHandler((ArtifactSelectorPresenter.ArtifactSelectHandler)Matchers.any());
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactSelectorPresenter((IsElement)this.artifactSelectorView);
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ArtifactSelectorPresenter)Mockito.verify((Object)this.artifactSelector, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testValidateForSubmit() {
        Mockito.when((Object)this.translationService.getTranslation("ContainerConfigPresenter.AllFieldsMustBeCompletedErrorMessage")).thenReturn((Object)ERROR_MESSAGE);
        this.presenter.clear();
        Assert.assertFalse((boolean)this.presenter.validateForSubmit());
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showFormError(ERROR_MESSAGE);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).clearFormError();
        Mockito.when((Object)this.view.getContainerName()).thenReturn((Object)CONTAINER_NAME_VALUE);
        Mockito.when((Object)this.provisioningValidationService.isValidContainerName(CONTAINER_NAME_VALUE)).thenReturn((Object)true);
        this.presenter.onContainerNameChange();
        Assert.assertFalse((boolean)this.presenter.validateForSubmit());
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).showFormError(ERROR_MESSAGE);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        Assert.assertFalse((boolean)this.presenter.validateForSubmit());
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).showFormError(ERROR_MESSAGE);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)ARTIFACT_ID_VALUE);
        Assert.assertFalse((boolean)this.presenter.validateForSubmit());
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)4))).showFormError(ERROR_MESSAGE);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)VERSION_VALUE);
        Assert.assertTrue((boolean)this.presenter.validateForSubmit());
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)4))).showFormError(ERROR_MESSAGE);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearFormError();
    }

    @Test
    public void testGetContainerConfig() {
        Mockito.when((Object)this.view.getContainerName()).thenReturn((Object)CONTAINER_NAME_VALUE);
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)ARTIFACT_ID_VALUE);
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)VERSION_VALUE);
        ContainerConfig containerConfig = this.presenter.getContainerConfig();
        Assert.assertEquals((Object)CONTAINER_NAME_VALUE, (Object)containerConfig.getName());
        Assert.assertEquals((Object)GROUP_ID_VALUE, (Object)containerConfig.getGroupId());
        Assert.assertEquals((Object)ARTIFACT_ID_VALUE, (Object)containerConfig.getArtifactId());
        Assert.assertEquals((Object)VERSION_VALUE, (Object)containerConfig.getVersion());
    }

    @Test
    public void testOnArtifactSelectedSuccessful() {
        GAV gav = new GAV(GROUP_ID_VALUE, ARTIFACT_ID_VALUE, VERSION_VALUE);
        Mockito.when((Object)this.m2RepoService.loadGAVFromJar(JAR_PATH)).thenReturn((Object)gav);
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)ARTIFACT_ID_VALUE);
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)VERSION_VALUE);
        this.presenter.onArtifactSelected(JAR_PATH);
        ((M2RepoService)Mockito.verify((Object)this.m2RepoService, (VerificationMode)Mockito.times((int)1))).loadGAVFromJar(JAR_PATH);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)4))).clearFormError();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupId(GROUP_ID_VALUE);
        ((ContainerConfigPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onGroupIdChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactId(ARTIFACT_ID_VALUE);
        ((ContainerConfigPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onArtifactIdChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersion(VERSION_VALUE);
        ((ContainerConfigPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onVersionChange();
    }

    @Test
    public void testOnArtifactSelectedFailed() {
        Mockito.when((Object)this.translationService.format("ContainerConfigPresenter.LoadGAVErrorMessage", new Object[]{"SERVICE_CALLER_EXCEPTION_MESSAGE"})).thenReturn((Object)ERROR_MESSAGE);
        ProvisioningManagementTestCommons.prepareServiceCallerError((Object)this.m2RepoService, this.m2RepoServiceCaller);
        this.presenter.onArtifactSelected(JAR_PATH);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showErrorPopup(ERROR_MESSAGE);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupId("");
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactId("");
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersion("");
    }

    @Test
    public void testOnContainerNameChangeValid() {
        Mockito.when((Object)this.view.getContainerName()).thenReturn((Object)CONTAINER_NAME_VALUE);
        Mockito.when((Object)this.provisioningValidationService.isValidContainerName(CONTAINER_NAME_VALUE)).thenReturn((Object)true);
        this.presenter.onContainerNameChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearContainerNameHelpText();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContainerNameStatus(FormStatus.VALID);
    }

    @Test
    public void testOnContainerNameChangeValidButAlreadyInUse() {
        ArrayList<String> alreadyInUseContainerNames = new ArrayList<String>();
        alreadyInUseContainerNames.add(CONTAINER_NAME_VALUE);
        this.presenter.setup(alreadyInUseContainerNames);
        Mockito.when((Object)this.view.getContainerName()).thenReturn((Object)CONTAINER_NAME_VALUE);
        Mockito.when((Object)this.provisioningValidationService.isValidContainerName(CONTAINER_NAME_VALUE)).thenReturn((Object)true);
        Mockito.when((Object)this.translationService.getTranslation("ContainerConfigPresenter.ContainerNameAlreadyInUseErrorMessage")).thenReturn((Object)ERROR_MESSAGE);
        this.presenter.onContainerNameChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearContainerNameHelpText();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContainerNameStatus(FormStatus.ERROR);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContainerNameHelpText(ERROR_MESSAGE);
    }

    @Test
    public void onContainerNameChangeInvalid() {
        Mockito.when((Object)this.view.getContainerName()).thenReturn((Object)CONTAINER_NAME_VALUE);
        Mockito.when((Object)this.provisioningValidationService.isValidContainerName(CONTAINER_NAME_VALUE)).thenReturn((Object)false);
        Mockito.when((Object)this.translationService.getTranslation("ContainerConfigPresenter.InvalidContainerNameErrorMessage")).thenReturn((Object)ERROR_MESSAGE);
        this.presenter.onContainerNameChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearContainerNameHelpText();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContainerNameStatus(FormStatus.ERROR);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setContainerNameHelpText(ERROR_MESSAGE);
    }

    @Test
    public void testOnGroupIdChangedValid() {
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        this.presenter.onGroupIdChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupIdStatus(FormStatus.VALID);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
    }

    @Test
    public void testOnGroupIdChangedInValid() {
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)"");
        this.presenter.onGroupIdChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupIdStatus(FormStatus.ERROR);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
    }

    @Test
    public void testOnArtifactIdChangedValid() {
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)ARTIFACT_ID_VALUE);
        this.presenter.onArtifactIdChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactIdStatus(FormStatus.VALID);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
    }

    @Test
    public void testOnArtifactIdChangedInValid() {
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)"");
        this.presenter.onArtifactIdChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactIdStatus(FormStatus.ERROR);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
    }

    @Test
    public void testOnVersionChangedValid() {
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)VERSION_VALUE);
        this.presenter.onVersionChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersionStatus(FormStatus.VALID);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
    }

    @Test
    public void testOnVersionChangedInValid() {
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)"");
        this.presenter.onVersionChange();
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersionStatus(FormStatus.ERROR);
        ((ContainerConfigPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearFormError();
    }
}

