/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.source;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.guvnor.ala.ui.client.util.ContentChangeHandler;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.wizard.source.SourceConfigurationParamsPresenter;
import org.guvnor.ala.ui.service.SourceService;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.spaces.Space;

@RunWith(value=GwtMockitoTestRunner.class)
public class SourceConfigurationParamsPresenterTest {
    private static final int ELEMENTS_SIZE = 5;
    private static final String SOME_VALUE = "SOME_VALUE";
    private static final String RUNTIME_NAME = "RUNTIME_NAME";
    private static final String OU = "OU";
    private static final String REPOSITORY = "REPOSITORY";
    private static final String BRANCH = "BRANCH";
    private static final String MODULE = "PROJECT";
    private static final Space SPACE = new Space("OU");
    @Mock
    private SourceConfigurationParamsPresenter.View view;
    @Mock
    private SourceService sourceService;
    private Caller<SourceService> sourceServiceCaller;
    @Mock
    private ContentChangeHandler changeHandler;
    private SourceConfigurationParamsPresenter presenter;
    private List<String> ous;
    private List<String> repositories;
    private List<String> branches;
    private List<Module> modules;

    @Before
    public void setUp() {
        this.ous = this.createOUs();
        this.repositories = this.createRepositories();
        this.branches = this.createBranches();
        this.modules = this.createModules();
        this.sourceServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.sourceService));
        this.presenter = new SourceConfigurationParamsPresenter(this.view, this.sourceServiceCaller);
        this.presenter.addContentChangeHandler(this.changeHandler);
        this.presenter.init();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testInitialize() {
        Mockito.when((Object)this.sourceService.getOrganizationUnits()).thenReturn(this.ous);
        this.presenter.initialise();
        this.ous.forEach(ou -> ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addOrganizationUnit(ou));
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearOrganizationUnits();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearRepositories();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearBranches();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearModules();
    }

    @Test
    public void testIsComplete() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getModule()).thenReturn((Object)"");
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)SOME_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)BRANCH);
        Mockito.when((Object)this.sourceService.getModules((Space)Matchers.eq((Object)SPACE), (String)Matchers.eq((Object)REPOSITORY), (String)Matchers.eq((Object)BRANCH))).thenReturn(this.modules);
        this.presenter.onBranchChange();
        int selectedModule = 1;
        String moduleName = this.modules.get(selectedModule).getModuleName();
        Mockito.when((Object)this.view.getModule()).thenReturn((Object)moduleName);
        this.presenter.isComplete(Assert::assertTrue);
    }

    @Test
    public void testBuildParams() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME);
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)BRANCH);
        Mockito.when((Object)this.sourceService.getModules((Space)Matchers.eq((Object)SPACE), (String)Matchers.eq((Object)REPOSITORY), (String)Matchers.eq((Object)BRANCH))).thenReturn(this.modules);
        Mockito.when((Object)this.view.getModule()).thenReturn((Object)MODULE);
        this.presenter.onBranchChange();
        int selectedModule = 2;
        String moduleName = this.modules.get(selectedModule).getModuleName();
        Mockito.when((Object)this.view.getModule()).thenReturn((Object)moduleName);
        Map params = this.presenter.buildParams();
        Assert.assertEquals((Object)RUNTIME_NAME, params.get("runtime-name"));
        Assert.assertEquals((Object)"OU/REPOSITORY", params.get("repo-name"));
        Assert.assertEquals((Object)BRANCH, params.get("branch"));
        Assert.assertEquals((Object)moduleName, params.get("module-dir"));
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testDisable() {
        this.presenter.disable();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).disable();
    }

    @Test
    public void testOnRuntimeChangeValid() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME);
        this.presenter.onRuntimeNameChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRuntimeStatus(FormStatus.VALID);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnRuntimeChangeInvalid() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)"");
        this.presenter.onRuntimeNameChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRuntimeStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnOrganizationalUnitChangeValid() {
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        Mockito.when((Object)this.sourceService.getRepositories(OU)).thenReturn(this.repositories);
        this.presenter.onOrganizationalUnitChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setOUStatus(FormStatus.VALID);
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getOU();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearRepositories();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearBranches();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearModules();
        this.verityRepositoriesWereLoaded();
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnOrganizationalUnitChangeInvalid() {
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)"");
        this.presenter.onOrganizationalUnitChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setOUStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnRepositoryChangeValid() {
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        Mockito.when((Object)this.sourceService.getBranches((Space)Matchers.eq((Object)SPACE), (String)Matchers.eq((Object)REPOSITORY))).thenReturn(this.branches);
        this.presenter.onRepositoryChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRepositoryStatus(FormStatus.VALID);
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearBranches();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearModules();
        this.verifyBranchesWereLoaded();
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnRepositoryChangeInvalid() {
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)"");
        this.presenter.onRepositoryChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRepositoryStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnBranchChangeValid() {
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)BRANCH);
        Mockito.when((Object)this.sourceService.getModules((Space)Matchers.eq((Object)SPACE), (String)Matchers.eq((Object)REPOSITORY), (String)Matchers.eq((Object)BRANCH))).thenReturn(this.modules);
        this.presenter.onBranchChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setBranchStatus(FormStatus.VALID);
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearModules();
        this.verifyProjectsWereLoaded();
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnBranchChangeInvalid() {
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)"");
        this.presenter.onBranchChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setBranchStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnProjectChangeValid() {
        Mockito.when((Object)this.view.getModule()).thenReturn((Object)MODULE);
        this.presenter.onModuleChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProjectStatus(FormStatus.VALID);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnProjectChangeInValid() {
        Mockito.when((Object)this.view.getModule()).thenReturn((Object)"");
        this.presenter.onModuleChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProjectStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    private void verityRepositoriesWereLoaded() {
        this.repositories.forEach(repository -> ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addRepository(repository));
    }

    private void verifyBranchesWereLoaded() {
        this.branches.forEach(branch -> ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addBranch(branch));
    }

    private void verifyProjectsWereLoaded() {
        this.modules.forEach(module -> ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addModule(module.getModuleName()));
    }

    private List<String> createOUs() {
        return this.createValues(5, "OU.name.");
    }

    private List<String> createRepositories() {
        return this.createValues(5, "REPO.name.");
    }

    private List<String> createBranches() {
        return this.createValues(5, "Branch.name.");
    }

    private List<Module> createModules() {
        ArrayList<Module> elements = new ArrayList<Module>();
        for (int i = 0; i < 5; ++i) {
            Module module = (Module)Mockito.mock(Module.class);
            Mockito.when((Object)module.getModuleName()).thenReturn((Object)("Module.name." + i));
            elements.add(module);
        }
        return elements;
    }

    private List<String> createValues(int size, String PREFIX) {
        ArrayList<String> elements = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            elements.add(PREFIX + i);
        }
        return elements;
    }

    private void verifyHandlerNotified() {
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }
}

